package com.docusign.rooms.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ActivityType
 */

public class ActivityType {
  @JsonProperty("activityTypeId")
  private String activityTypeId = null;

  @JsonProperty("name")
  private String name = null;

  public ActivityType activityTypeId(String activityTypeId) {
    this.activityTypeId = activityTypeId;
    return this;
  }

   /**
   * Get activityTypeId
   * @return activityTypeId
  **/
  @ApiModelProperty(value = "")
  public String getActivityTypeId() {
    return activityTypeId;
  }

  public void setActivityTypeId(String activityTypeId) {
    this.activityTypeId = activityTypeId;
  }

  public ActivityType name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityType activityType = (ActivityType) o;
    return Objects.equals(this.activityTypeId, activityType.activityTypeId) &&
        Objects.equals(this.name, activityType.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activityTypeId, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityType {\n");
    
    sb.append("    activityTypeId: ").append(toIndentedString(activityTypeId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

