/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.Document;
import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.Recipients;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InlineTemplate {
    @JsonProperty(value="customFields")
    private CustomFields customFields = null;
    @JsonProperty(value="documents")
    private List<Document> documents = null;
    @JsonProperty(value="envelope")
    private Envelope envelope = null;
    @JsonProperty(value="recipients")
    private Recipients recipients = null;
    @JsonProperty(value="sequence")
    private String sequence = null;

    public InlineTemplate customFields(CustomFields customFields) {
        this.customFields = customFields;
        return this;
    }

    @Schema(description="An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
    public CustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomFields customFields) {
        this.customFields = customFields;
    }

    public InlineTemplate documents(List<Document> documents) {
        this.documents = documents;
        return this;
    }

    public InlineTemplate addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Schema(description="Complex element contains the details on the documents in the envelope.")
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public InlineTemplate envelope(Envelope envelope) {
        this.envelope = envelope;
        return this;
    }

    @Schema(description="A container used to send documents to recipients. The envelope carries information about the sender and timestamps to indicate the progress of the delivery procedure. It can contain collections of Documents, Tabs and Recipients.")
    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public InlineTemplate recipients(Recipients recipients) {
        this.recipients = recipients;
        return this;
    }

    @Schema(description="An array of powerform recipients.")
    public Recipients getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Recipients recipients) {
        this.recipients = recipients;
    }

    public InlineTemplate sequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    @Schema(description="Specifies the order in which templates are overlaid.")
    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineTemplate inlineTemplate = (InlineTemplate)o;
        return Objects.equals(this.customFields, inlineTemplate.customFields) && Objects.equals(this.documents, inlineTemplate.documents) && Objects.equals(this.envelope, inlineTemplate.envelope) && Objects.equals(this.recipients, inlineTemplate.recipients) && Objects.equals(this.sequence, inlineTemplate.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.customFields, this.documents, this.envelope, this.recipients, this.sequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineTemplate {\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    envelope: ").append(this.toIndentedString(this.envelope)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

