/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ConnectEventData;
import com.docusign.esign.model.EnvelopeEvent;
import com.docusign.esign.model.RecipientEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This optional complex element allows a message to be sent a specified URL when the envelope or recipient changes status. It is similar to DocuSign Connect. For example, if an envelope changes from \"Sent\" to \"Delivered\", a message containing the updated envelope status and optionally the documents is sent to the URL. When an eventNotification is attached to an envelope using the API, it only applies to the envelope (treating the envelope as the sender). This is different from envelopes created through the console user interface, where the user is treated as the sender.")
public class EventNotification {
    @JsonProperty(value="envelopeEvents")
    private List<EnvelopeEvent> envelopeEvents = new ArrayList<EnvelopeEvent>();
    @JsonProperty(value="eventData")
    private ConnectEventData eventData = null;
    @JsonProperty(value="includeCertificateOfCompletion")
    private String includeCertificateOfCompletion = null;
    @JsonProperty(value="includeCertificateWithSoap")
    private String includeCertificateWithSoap = null;
    @JsonProperty(value="includeDocumentFields")
    private String includeDocumentFields = null;
    @JsonProperty(value="includeDocuments")
    private String includeDocuments = null;
    @JsonProperty(value="includeEnvelopeVoidReason")
    private String includeEnvelopeVoidReason = null;
    @JsonProperty(value="includeHMAC")
    private String includeHMAC = null;
    @JsonProperty(value="includeSenderAccountAsCustomField")
    private String includeSenderAccountAsCustomField = null;
    @JsonProperty(value="includeTimeZone")
    private String includeTimeZone = null;
    @JsonProperty(value="loggingEnabled")
    private String loggingEnabled = null;
    @JsonProperty(value="recipientEvents")
    private List<RecipientEvent> recipientEvents = new ArrayList<RecipientEvent>();
    @JsonProperty(value="requireAcknowledgment")
    private String requireAcknowledgment = null;
    @JsonProperty(value="signMessageWithX509Cert")
    private String signMessageWithX509Cert = null;
    @JsonProperty(value="soapNameSpace")
    private String soapNameSpace = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="useSoapInterface")
    private String useSoapInterface = null;

    public EventNotification envelopeEvents(List<EnvelopeEvent> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
        return this;
    }

    public EventNotification addEnvelopeEventsItem(EnvelopeEvent envelopeEventsItem) {
        this.envelopeEvents.add(envelopeEventsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `url` property.   To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.")
    public List<EnvelopeEvent> getEnvelopeEvents() {
        return this.envelopeEvents;
    }

    public void setEnvelopeEvents(List<EnvelopeEvent> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
    }

    public EventNotification eventData(ConnectEventData eventData) {
        this.eventData = eventData;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ConnectEventData getEventData() {
        return this.eventData;
    }

    public void setEventData(ConnectEventData eventData) {
        this.eventData = eventData;
    }

    public EventNotification includeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes. ")
    public String getIncludeCertificateOfCompletion() {
        return this.includeCertificateOfCompletion;
    }

    public void setIncludeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
    }

    public EventNotification includeCertificateWithSoap(String includeCertificateWithSoap) {
        this.includeCertificateWithSoap = includeCertificateWithSoap;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, this tells the Connect service to send the DocuSign signedby certificate as part of the outgoing SOAP xml. This appears in the XML as wsse:BinarySecurityToken.")
    public String getIncludeCertificateWithSoap() {
        return this.includeCertificateWithSoap;
    }

    public void setIncludeCertificateWithSoap(String includeCertificateWithSoap) {
        this.includeCertificateWithSoap = includeCertificateWithSoap;
    }

    public EventNotification includeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API. ")
    public String getIncludeDocumentFields() {
        return this.includeDocumentFields;
    }

    public void setIncludeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
    }

    public EventNotification includeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the PDF documents are included in the message along with the updated XML. ")
    public String getIncludeDocuments() {
        return this.includeDocuments;
    }

    public void setIncludeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
    }

    public EventNotification includeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, this tells the Connect Service to include the void reason, as entered by the person that voided the envelope, in the message. ")
    public String getIncludeEnvelopeVoidReason() {
        return this.includeEnvelopeVoidReason;
    }

    public void setIncludeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
    }

    public EventNotification includeHMAC(String includeHMAC) {
        this.includeHMAC = includeHMAC;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getIncludeHMAC() {
        return this.includeHMAC;
    }

    public void setIncludeHMAC(String includeHMAC) {
        this.includeHMAC = includeHMAC;
    }

    public EventNotification includeSenderAccountAsCustomField(String includeSenderAccountAsCustomField) {
        this.includeSenderAccountAsCustomField = includeSenderAccountAsCustomField;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender account ID is included as a envelope custom field in the data. ")
    public String getIncludeSenderAccountAsCustomField() {
        return this.includeSenderAccountAsCustomField;
    }

    public void setIncludeSenderAccountAsCustomField(String includeSenderAccountAsCustomField) {
        this.includeSenderAccountAsCustomField = includeSenderAccountAsCustomField;
    }

    public EventNotification includeTimeZone(String includeTimeZone) {
        this.includeTimeZone = includeTimeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the envelope time zone information is included in the message. ")
    public String getIncludeTimeZone() {
        return this.includeTimeZone;
    }

    public void setIncludeTimeZone(String includeTimeZone) {
        this.includeTimeZone = includeTimeZone;
    }

    public EventNotification loggingEnabled(String loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, logging is turned on for envelope events on the Web Console Connect page. ")
    public String getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(String loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public EventNotification recipientEvents(List<RecipientEvent> recipientEvents) {
        this.recipientEvents = recipientEvents;
        return this;
    }

    public EventNotification addRecipientEventsItem(RecipientEvent recipientEventsItem) {
        this.recipientEvents.add(recipientEventsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A list of recipient event statuses that will trigger Connect to send updates to   the endpoint specified in the url property.  To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.")
    public List<RecipientEvent> getRecipientEvents() {
        return this.recipientEvents;
    }

    public void setRecipientEvents(List<RecipientEvent> recipientEvents) {
        this.recipientEvents = recipientEvents;
    }

    public EventNotification requireAcknowledgment(String requireAcknowledgment) {
        this.requireAcknowledgment = requireAcknowledgment;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the DocuSign Connect service checks that the message was received and retries on failures. ")
    public String getRequireAcknowledgment() {
        return this.requireAcknowledgment;
    }

    public void setRequireAcknowledgment(String requireAcknowledgment) {
        this.requireAcknowledgment = requireAcknowledgment;
    }

    public EventNotification signMessageWithX509Cert(String signMessageWithX509Cert) {
        this.signMessageWithX509Cert = signMessageWithX509Cert;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, messages are signed with an X509 certificate. This provides support for 2-way SSL in the envelope. ")
    public String getSignMessageWithX509Cert() {
        return this.signMessageWithX509Cert;
    }

    public void setSignMessageWithX509Cert(String signMessageWithX509Cert) {
        this.signMessageWithX509Cert = signMessageWithX509Cert;
    }

    public EventNotification soapNameSpace(String soapNameSpace) {
        this.soapNameSpace = soapNameSpace;
        return this;
    }

    @ApiModelProperty(example="null", value="This lists the namespace in the SOAP listener provided.")
    public String getSoapNameSpace() {
        return this.soapNameSpace;
    }

    public void setSoapNameSpace(String soapNameSpace) {
        this.soapNameSpace = soapNameSpace;
    }

    public EventNotification url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the endpoint to which envelope updates are sent. Udpates are sent as XML unless `useSoapInterface` property is set to **true**.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public EventNotification useSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, this tells the Connect service that the user's endpoint has implemented a SOAP interface. ")
    public String getUseSoapInterface() {
        return this.useSoapInterface;
    }

    public void setUseSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventNotification eventNotification = (EventNotification)o;
        return Objects.equals(this.envelopeEvents, eventNotification.envelopeEvents) && Objects.equals(this.eventData, eventNotification.eventData) && Objects.equals(this.includeCertificateOfCompletion, eventNotification.includeCertificateOfCompletion) && Objects.equals(this.includeCertificateWithSoap, eventNotification.includeCertificateWithSoap) && Objects.equals(this.includeDocumentFields, eventNotification.includeDocumentFields) && Objects.equals(this.includeDocuments, eventNotification.includeDocuments) && Objects.equals(this.includeEnvelopeVoidReason, eventNotification.includeEnvelopeVoidReason) && Objects.equals(this.includeHMAC, eventNotification.includeHMAC) && Objects.equals(this.includeSenderAccountAsCustomField, eventNotification.includeSenderAccountAsCustomField) && Objects.equals(this.includeTimeZone, eventNotification.includeTimeZone) && Objects.equals(this.loggingEnabled, eventNotification.loggingEnabled) && Objects.equals(this.recipientEvents, eventNotification.recipientEvents) && Objects.equals(this.requireAcknowledgment, eventNotification.requireAcknowledgment) && Objects.equals(this.signMessageWithX509Cert, eventNotification.signMessageWithX509Cert) && Objects.equals(this.soapNameSpace, eventNotification.soapNameSpace) && Objects.equals(this.url, eventNotification.url) && Objects.equals(this.useSoapInterface, eventNotification.useSoapInterface);
    }

    public int hashCode() {
        return Objects.hash(this.envelopeEvents, this.eventData, this.includeCertificateOfCompletion, this.includeCertificateWithSoap, this.includeDocumentFields, this.includeDocuments, this.includeEnvelopeVoidReason, this.includeHMAC, this.includeSenderAccountAsCustomField, this.includeTimeZone, this.loggingEnabled, this.recipientEvents, this.requireAcknowledgment, this.signMessageWithX509Cert, this.soapNameSpace, this.url, this.useSoapInterface);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventNotification {\n");
        sb.append("    envelopeEvents: ").append(this.toIndentedString(this.envelopeEvents)).append("\n");
        sb.append("    eventData: ").append(this.toIndentedString(this.eventData)).append("\n");
        sb.append("    includeCertificateOfCompletion: ").append(this.toIndentedString(this.includeCertificateOfCompletion)).append("\n");
        sb.append("    includeCertificateWithSoap: ").append(this.toIndentedString(this.includeCertificateWithSoap)).append("\n");
        sb.append("    includeDocumentFields: ").append(this.toIndentedString(this.includeDocumentFields)).append("\n");
        sb.append("    includeDocuments: ").append(this.toIndentedString(this.includeDocuments)).append("\n");
        sb.append("    includeEnvelopeVoidReason: ").append(this.toIndentedString(this.includeEnvelopeVoidReason)).append("\n");
        sb.append("    includeHMAC: ").append(this.toIndentedString(this.includeHMAC)).append("\n");
        sb.append("    includeSenderAccountAsCustomField: ").append(this.toIndentedString(this.includeSenderAccountAsCustomField)).append("\n");
        sb.append("    includeTimeZone: ").append(this.toIndentedString(this.includeTimeZone)).append("\n");
        sb.append("    loggingEnabled: ").append(this.toIndentedString(this.loggingEnabled)).append("\n");
        sb.append("    recipientEvents: ").append(this.toIndentedString(this.recipientEvents)).append("\n");
        sb.append("    requireAcknowledgment: ").append(this.toIndentedString(this.requireAcknowledgment)).append("\n");
        sb.append("    signMessageWithX509Cert: ").append(this.toIndentedString(this.signMessageWithX509Cert)).append("\n");
        sb.append("    soapNameSpace: ").append(this.toIndentedString(this.soapNameSpace)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    useSoapInterface: ").append(this.toIndentedString(this.useSoapInterface)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

