/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.DocumentHtmlDefinition;
import com.docusign.esign.model.MatchBox;
import com.docusign.esign.model.NameValue;
import com.docusign.esign.model.OcrRequest;
import com.docusign.esign.model.PageSize;
import com.docusign.esign.model.Tabs;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Document {
    @JsonProperty(value="applyAnchorTabs")
    private String applyAnchorTabs = null;
    @JsonProperty(value="display")
    private String display = null;
    @JsonProperty(value="documentBase64")
    private String documentBase64 = null;
    @JsonProperty(value="documentFields")
    private List<NameValue> documentFields = new ArrayList<NameValue>();
    @JsonProperty(value="documentId")
    private String documentId = null;
    @JsonProperty(value="encryptedWithKeyManager")
    private String encryptedWithKeyManager = null;
    @JsonProperty(value="fileExtension")
    private String fileExtension = null;
    @JsonProperty(value="fileFormatHint")
    private String fileFormatHint = null;
    @JsonProperty(value="htmlDefinition")
    private DocumentHtmlDefinition htmlDefinition = null;
    @JsonProperty(value="includeInDownload")
    private String includeInDownload = null;
    @JsonProperty(value="isDynamicXfa")
    private Boolean isDynamicXfa = null;
    @JsonProperty(value="isStaticXfa")
    private Boolean isStaticXfa = null;
    @JsonProperty(value="matchBoxes")
    private List<MatchBox> matchBoxes = new ArrayList<MatchBox>();
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="ocrRequests")
    private List<OcrRequest> ocrRequests = new ArrayList<OcrRequest>();
    @JsonProperty(value="order")
    private String order = null;
    @JsonProperty(value="pageCount")
    private String pageCount = null;
    @JsonProperty(value="pages")
    private String pages = null;
    @JsonProperty(value="pageSizes")
    private List<PageSize> pageSizes = new ArrayList<PageSize>();
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="pdfFieldsData")
    private String pdfFieldsData = null;
    @JsonProperty(value="pdfFormFieldOption")
    private String pdfFormFieldOption = null;
    @JsonProperty(value="pdfWidgetsBase64")
    private String pdfWidgetsBase64 = null;
    @JsonProperty(value="remoteUrl")
    private String remoteUrl = null;
    @JsonProperty(value="signerMustAcknowledge")
    private String signerMustAcknowledge = null;
    @JsonProperty(value="signerMustAcknowledgeUseAccountDefault")
    private Boolean signerMustAcknowledgeUseAccountDefault = null;
    @JsonProperty(value="tabs")
    private Tabs tabs = null;
    @JsonProperty(value="templateLocked")
    private String templateLocked = null;
    @JsonProperty(value="templateRequired")
    private String templateRequired = null;
    @JsonProperty(value="transformPdfFields")
    private String transformPdfFields = null;
    @JsonProperty(value="uri")
    private String uri = null;

    public Document applyAnchorTabs(String applyAnchorTabs) {
        this.applyAnchorTabs = applyAnchorTabs;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getApplyAnchorTabs() {
        return this.applyAnchorTabs;
    }

    public void setApplyAnchorTabs(String applyAnchorTabs) {
        this.applyAnchorTabs = applyAnchorTabs;
    }

    public Document display(String display) {
        this.display = display;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Document documentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
        return this;
    }

    @ApiModelProperty(example="null", value="The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.")
    public String getDocumentBase64() {
        return this.documentBase64;
    }

    public void setDocumentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
    }

    public Document documentFields(List<NameValue> documentFields) {
        this.documentFields = documentFields;
        return this;
    }

    public Document addDocumentFieldsItem(NameValue documentFieldsItem) {
        this.documentFields.add(documentFieldsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<NameValue> getDocumentFields() {
        return this.documentFields;
    }

    public void setDocumentFields(List<NameValue> documentFields) {
        this.documentFields = documentFields;
    }

    public Document documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Document encryptedWithKeyManager(String encryptedWithKeyManager) {
        this.encryptedWithKeyManager = encryptedWithKeyManager;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the document is been already encrypted by the sender for use with the DocuSign Key Manager Security Appliance.  ")
    public String getEncryptedWithKeyManager() {
        return this.encryptedWithKeyManager;
    }

    public void setEncryptedWithKeyManager(String encryptedWithKeyManager) {
        this.encryptedWithKeyManager = encryptedWithKeyManager;
    }

    public Document fileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @ApiModelProperty(example="null", value="The file extension type of the document. If the document is not a PDF it is converted to a PDF.  ")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public Document fileFormatHint(String fileFormatHint) {
        this.fileFormatHint = fileFormatHint;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getFileFormatHint() {
        return this.fileFormatHint;
    }

    public void setFileFormatHint(String fileFormatHint) {
        this.fileFormatHint = fileFormatHint;
    }

    public Document htmlDefinition(DocumentHtmlDefinition htmlDefinition) {
        this.htmlDefinition = htmlDefinition;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DocumentHtmlDefinition getHtmlDefinition() {
        return this.htmlDefinition;
    }

    public void setHtmlDefinition(DocumentHtmlDefinition htmlDefinition) {
        this.htmlDefinition = htmlDefinition;
    }

    public Document includeInDownload(String includeInDownload) {
        this.includeInDownload = includeInDownload;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getIncludeInDownload() {
        return this.includeInDownload;
    }

    public void setIncludeInDownload(String includeInDownload) {
        this.includeInDownload = includeInDownload;
    }

    public Document isDynamicXfa(Boolean isDynamicXfa) {
        this.isDynamicXfa = isDynamicXfa;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Boolean getIsDynamicXfa() {
        return this.isDynamicXfa;
    }

    public void setIsDynamicXfa(Boolean isDynamicXfa) {
        this.isDynamicXfa = isDynamicXfa;
    }

    public Document isStaticXfa(Boolean isStaticXfa) {
        this.isStaticXfa = isStaticXfa;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Boolean getIsStaticXfa() {
        return this.isStaticXfa;
    }

    public void setIsStaticXfa(Boolean isStaticXfa) {
        this.isStaticXfa = isStaticXfa;
    }

    public Document matchBoxes(List<MatchBox> matchBoxes) {
        this.matchBoxes = matchBoxes;
        return this;
    }

    public Document addMatchBoxesItem(MatchBox matchBoxesItem) {
        this.matchBoxes.add(matchBoxesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Matchboxes define areas in a document for document matching when you are creating envelopes. They are only used when you upload and edit a template.   A matchbox consists of 5 elements:  * pageNumber - The document page number  on which the matchbox will appear.  * xPosition - The x position of the matchbox on a page.  * yPosition - The y position of the matchbox on a page. * width - The width of the matchbox.  * height - The height of the matchbox.  ")
    public List<MatchBox> getMatchBoxes() {
        return this.matchBoxes;
    }

    public void setMatchBoxes(List<MatchBox> matchBoxes) {
        this.matchBoxes = matchBoxes;
    }

    public Document name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Document ocrRequests(List<OcrRequest> ocrRequests) {
        this.ocrRequests = ocrRequests;
        return this;
    }

    public Document addOcrRequestsItem(OcrRequest ocrRequestsItem) {
        this.ocrRequests.add(ocrRequestsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<OcrRequest> getOcrRequests() {
        return this.ocrRequests;
    }

    public void setOcrRequests(List<OcrRequest> ocrRequests) {
        this.ocrRequests = ocrRequests;
    }

    public Document order(String order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Document pageCount(String pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(String pageCount) {
        this.pageCount = pageCount;
    }

    public Document pages(String pages) {
        this.pages = pages;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPages() {
        return this.pages;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    public Document pageSizes(List<PageSize> pageSizes) {
        this.pageSizes = pageSizes;
        return this;
    }

    public Document addPageSizesItem(PageSize pageSizesItem) {
        this.pageSizes.add(pageSizesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<PageSize> getPageSizes() {
        return this.pageSizes;
    }

    public void setPageSizes(List<PageSize> pageSizes) {
        this.pageSizes = pageSizes;
    }

    public Document password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Document pdfFieldsData(String pdfFieldsData) {
        this.pdfFieldsData = pdfFieldsData;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPdfFieldsData() {
        return this.pdfFieldsData;
    }

    public void setPdfFieldsData(String pdfFieldsData) {
        this.pdfFieldsData = pdfFieldsData;
    }

    public Document pdfFormFieldOption(String pdfFormFieldOption) {
        this.pdfFormFieldOption = pdfFormFieldOption;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPdfFormFieldOption() {
        return this.pdfFormFieldOption;
    }

    public void setPdfFormFieldOption(String pdfFormFieldOption) {
        this.pdfFormFieldOption = pdfFormFieldOption;
    }

    public Document pdfWidgetsBase64(String pdfWidgetsBase64) {
        this.pdfWidgetsBase64 = pdfWidgetsBase64;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPdfWidgetsBase64() {
        return this.pdfWidgetsBase64;
    }

    public void setPdfWidgetsBase64(String pdfWidgetsBase64) {
        this.pdfWidgetsBase64 = pdfWidgetsBase64;
    }

    public Document remoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The file id from the cloud storage service where the document is located. This information is returned using [ML:GET /folders] or [ML:/folders/{folderid}]. ")
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public Document signerMustAcknowledge(String signerMustAcknowledge) {
        this.signerMustAcknowledge = signerMustAcknowledge;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getSignerMustAcknowledge() {
        return this.signerMustAcknowledge;
    }

    public void setSignerMustAcknowledge(String signerMustAcknowledge) {
        this.signerMustAcknowledge = signerMustAcknowledge;
    }

    public Document signerMustAcknowledgeUseAccountDefault(Boolean signerMustAcknowledgeUseAccountDefault) {
        this.signerMustAcknowledgeUseAccountDefault = signerMustAcknowledgeUseAccountDefault;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Boolean getSignerMustAcknowledgeUseAccountDefault() {
        return this.signerMustAcknowledgeUseAccountDefault;
    }

    public void setSignerMustAcknowledgeUseAccountDefault(Boolean signerMustAcknowledgeUseAccountDefault) {
        this.signerMustAcknowledgeUseAccountDefault = signerMustAcknowledgeUseAccountDefault;
    }

    public Document tabs(Tabs tabs) {
        this.tabs = tabs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Tabs getTabs() {
        return this.tabs;
    }

    public void setTabs(Tabs tabs) {
        this.tabs = tabs;
    }

    public Document templateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. ")
    public String getTemplateLocked() {
        return this.templateLocked;
    }

    public void setTemplateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
    }

    public Document templateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.")
    public String getTemplateRequired() {
        return this.templateRequired;
    }

    public void setTemplateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
    }

    public Document transformPdfFields(String transformPdfFields) {
        this.transformPdfFields = transformPdfFields;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, PDF form field data is transformed into document tab values when the PDF form field name matches the DocuSign custom tab tabLabel. The resulting PDF form data is also returned in the PDF meta data when requesting the document PDF. See the [ML:Transform PDF Fields] section for more information about how fields are transformed into DocuSign tabs. ")
    public String getTransformPdfFields() {
        return this.transformPdfFields;
    }

    public void setTransformPdfFields(String transformPdfFields) {
        this.transformPdfFields = transformPdfFields;
    }

    public Document uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.applyAnchorTabs, document.applyAnchorTabs) && Objects.equals(this.display, document.display) && Objects.equals(this.documentBase64, document.documentBase64) && Objects.equals(this.documentFields, document.documentFields) && Objects.equals(this.documentId, document.documentId) && Objects.equals(this.encryptedWithKeyManager, document.encryptedWithKeyManager) && Objects.equals(this.fileExtension, document.fileExtension) && Objects.equals(this.fileFormatHint, document.fileFormatHint) && Objects.equals(this.htmlDefinition, document.htmlDefinition) && Objects.equals(this.includeInDownload, document.includeInDownload) && Objects.equals(this.isDynamicXfa, document.isDynamicXfa) && Objects.equals(this.isStaticXfa, document.isStaticXfa) && Objects.equals(this.matchBoxes, document.matchBoxes) && Objects.equals(this.name, document.name) && Objects.equals(this.ocrRequests, document.ocrRequests) && Objects.equals(this.order, document.order) && Objects.equals(this.pageCount, document.pageCount) && Objects.equals(this.pages, document.pages) && Objects.equals(this.pageSizes, document.pageSizes) && Objects.equals(this.password, document.password) && Objects.equals(this.pdfFieldsData, document.pdfFieldsData) && Objects.equals(this.pdfFormFieldOption, document.pdfFormFieldOption) && Objects.equals(this.pdfWidgetsBase64, document.pdfWidgetsBase64) && Objects.equals(this.remoteUrl, document.remoteUrl) && Objects.equals(this.signerMustAcknowledge, document.signerMustAcknowledge) && Objects.equals(this.signerMustAcknowledgeUseAccountDefault, document.signerMustAcknowledgeUseAccountDefault) && Objects.equals(this.tabs, document.tabs) && Objects.equals(this.templateLocked, document.templateLocked) && Objects.equals(this.templateRequired, document.templateRequired) && Objects.equals(this.transformPdfFields, document.transformPdfFields) && Objects.equals(this.uri, document.uri);
    }

    public int hashCode() {
        return Objects.hash(this.applyAnchorTabs, this.display, this.documentBase64, this.documentFields, this.documentId, this.encryptedWithKeyManager, this.fileExtension, this.fileFormatHint, this.htmlDefinition, this.includeInDownload, this.isDynamicXfa, this.isStaticXfa, this.matchBoxes, this.name, this.ocrRequests, this.order, this.pageCount, this.pages, this.pageSizes, this.password, this.pdfFieldsData, this.pdfFormFieldOption, this.pdfWidgetsBase64, this.remoteUrl, this.signerMustAcknowledge, this.signerMustAcknowledgeUseAccountDefault, this.tabs, this.templateLocked, this.templateRequired, this.transformPdfFields, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    applyAnchorTabs: ").append(this.toIndentedString(this.applyAnchorTabs)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    documentBase64: ").append(this.toIndentedString(this.documentBase64)).append("\n");
        sb.append("    documentFields: ").append(this.toIndentedString(this.documentFields)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    encryptedWithKeyManager: ").append(this.toIndentedString(this.encryptedWithKeyManager)).append("\n");
        sb.append("    fileExtension: ").append(this.toIndentedString(this.fileExtension)).append("\n");
        sb.append("    fileFormatHint: ").append(this.toIndentedString(this.fileFormatHint)).append("\n");
        sb.append("    htmlDefinition: ").append(this.toIndentedString(this.htmlDefinition)).append("\n");
        sb.append("    includeInDownload: ").append(this.toIndentedString(this.includeInDownload)).append("\n");
        sb.append("    isDynamicXfa: ").append(this.toIndentedString(this.isDynamicXfa)).append("\n");
        sb.append("    isStaticXfa: ").append(this.toIndentedString(this.isStaticXfa)).append("\n");
        sb.append("    matchBoxes: ").append(this.toIndentedString(this.matchBoxes)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ocrRequests: ").append(this.toIndentedString(this.ocrRequests)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    pageSizes: ").append(this.toIndentedString(this.pageSizes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    pdfFieldsData: ").append(this.toIndentedString(this.pdfFieldsData)).append("\n");
        sb.append("    pdfFormFieldOption: ").append(this.toIndentedString(this.pdfFormFieldOption)).append("\n");
        sb.append("    pdfWidgetsBase64: ").append(this.toIndentedString(this.pdfWidgetsBase64)).append("\n");
        sb.append("    remoteUrl: ").append(this.toIndentedString(this.remoteUrl)).append("\n");
        sb.append("    signerMustAcknowledge: ").append(this.toIndentedString(this.signerMustAcknowledge)).append("\n");
        sb.append("    signerMustAcknowledgeUseAccountDefault: ").append(this.toIndentedString(this.signerMustAcknowledgeUseAccountDefault)).append("\n");
        sb.append("    tabs: ").append(this.toIndentedString(this.tabs)).append("\n");
        sb.append("    templateLocked: ").append(this.toIndentedString(this.templateLocked)).append("\n");
        sb.append("    templateRequired: ").append(this.toIndentedString(this.templateRequired)).append("\n");
        sb.append("    transformPdfFields: ").append(this.toIndentedString(this.transformPdfFields)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

