/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.MemberSharedItems;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains shared access information.")
public class AccountSharedAccess {
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="nextUri")
    private String nextUri = null;
    @JsonProperty(value="previousUri")
    private String previousUri = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="sharedAccess")
    private List<MemberSharedItems> sharedAccess = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalSetSize")
    private String totalSetSize = null;

    public AccountSharedAccess accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The account ID associated with the envelope.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountSharedAccess endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @ApiModelProperty(value="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public AccountSharedAccess errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public AccountSharedAccess nextUri(String nextUri) {
        this.nextUri = nextUri;
        return this;
    }

    @ApiModelProperty(value="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null. ")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    public AccountSharedAccess previousUri(String previousUri) {
        this.previousUri = previousUri;
        return this;
    }

    @ApiModelProperty(value="The postal code for the billing address.")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    public AccountSharedAccess resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @ApiModelProperty(value="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public AccountSharedAccess sharedAccess(List<MemberSharedItems> sharedAccess) {
        this.sharedAccess = sharedAccess;
        return this;
    }

    public AccountSharedAccess addSharedAccessItem(MemberSharedItems sharedAccessItem) {
        if (this.sharedAccess == null) {
            this.sharedAccess = new ArrayList<MemberSharedItems>();
        }
        this.sharedAccess.add(sharedAccessItem);
        return this;
    }

    @ApiModelProperty(value="A complex type containing the shared access information to an envelope for the users specified in the request.")
    public List<MemberSharedItems> getSharedAccess() {
        return this.sharedAccess;
    }

    public void setSharedAccess(List<MemberSharedItems> sharedAccess) {
        this.sharedAccess = sharedAccess;
    }

    public AccountSharedAccess startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @ApiModelProperty(value="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public AccountSharedAccess totalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @ApiModelProperty(value="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSharedAccess accountSharedAccess = (AccountSharedAccess)o;
        return Objects.equals(this.accountId, accountSharedAccess.accountId) && Objects.equals(this.endPosition, accountSharedAccess.endPosition) && Objects.equals(this.errorDetails, accountSharedAccess.errorDetails) && Objects.equals(this.nextUri, accountSharedAccess.nextUri) && Objects.equals(this.previousUri, accountSharedAccess.previousUri) && Objects.equals(this.resultSetSize, accountSharedAccess.resultSetSize) && Objects.equals(this.sharedAccess, accountSharedAccess.sharedAccess) && Objects.equals(this.startPosition, accountSharedAccess.startPosition) && Objects.equals(this.totalSetSize, accountSharedAccess.totalSetSize);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.endPosition, this.errorDetails, this.nextUri, this.previousUri, this.resultSetSize, this.sharedAccess, this.startPosition, this.totalSetSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountSharedAccess {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    sharedAccess: ").append(this.toIndentedString(this.sharedAccess)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

