/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BulkSendBatchRequest;
import com.docusign.esign.model.BulkSendBatchStatus;
import com.docusign.esign.model.BulkSendBatchSummaries;
import com.docusign.esign.model.BulkSendRequest;
import com.docusign.esign.model.BulkSendResponse;
import com.docusign.esign.model.BulkSendTestResponse;
import com.docusign.esign.model.BulkSendingList;
import com.docusign.esign.model.BulkSendingListSummaries;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BulkEnvelopesApi {
    private ApiClient apiClient;

    public BulkEnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkEnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BulkSendingList createBulkSendList(String accountId, BulkSendingList bulkSendingList) throws ApiException {
        BulkSendingList localVarPostBody = bulkSendingList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendResponse createBulkSendRequest(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        BulkSendRequest localVarPostBody = bulkSendRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendRequest");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling createBulkSendRequest");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendResponse> localVarReturnType = new GenericType<BulkSendResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendTestResponse createBulkSendTestRequest(String accountId, String bulkSendListId, BulkSendRequest bulkSendRequest) throws ApiException {
        BulkSendRequest localVarPostBody = bulkSendRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkSendTestRequest");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling createBulkSendTestRequest");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendTestResponse> localVarReturnType = new GenericType<BulkSendTestResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendingListSummaries deleteBulkSendList(String accountId, String bulkSendListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling deleteBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingListSummaries> localVarReturnType = new GenericType<BulkSendingListSummaries>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendBatchStatus getBulkSendBatchStatus(String accountId, String bulkSendBatchId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendBatchStatus");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling getBulkSendBatchStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchStatus> localVarReturnType = new GenericType<BulkSendBatchStatus>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendBatchSummaries getBulkSendBatches(String accountId) throws ApiException {
        return this.getBulkSendBatches(accountId, null);
    }

    public BulkSendBatchSummaries getBulkSendBatches(String accountId, GetBulkSendBatchesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendBatches");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("batch_ids", options.batchIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchSummaries> localVarReturnType = new GenericType<BulkSendBatchSummaries>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendingList getBulkSendList(String accountId, String bulkSendListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling getBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendingListSummaries getBulkSendLists(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkSendLists");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingListSummaries> localVarReturnType = new GenericType<BulkSendingListSummaries>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendBatchStatus updateBulkSendBatchStatus(String accountId, String bulkSendBatchId, BulkSendBatchRequest bulkSendBatchRequest) throws ApiException {
        BulkSendBatchRequest localVarPostBody = bulkSendBatchRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkSendBatchStatus");
        }
        if (bulkSendBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendBatchId' when calling updateBulkSendBatchStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendBatchId\\}", this.apiClient.escapeString(bulkSendBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendBatchStatus> localVarReturnType = new GenericType<BulkSendBatchStatus>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkSendingList updateBulkSendList(String accountId, String bulkSendListId, BulkSendingList bulkSendingList) throws ApiException {
        BulkSendingList localVarPostBody = bulkSendingList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkSendList");
        }
        if (bulkSendListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkSendListId' when calling updateBulkSendList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bulkSendListId\\}", this.apiClient.escapeString(bulkSendListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkSendingList> localVarReturnType = new GenericType<BulkSendingList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetBulkSendBatchesOptions {
        private String batchIds = null;
        private String count = null;
        private String startPosition = null;
        private String status = null;

        public void setBatchIds(String batchIds) {
            this.batchIds = batchIds;
        }

        public String getBatchIds() {
            return this.batchIds;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

