/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Radio {
    private String pageNumber = null;
    private String xPosition = null;
    private String yPosition = null;
    private String anchorString = null;
    private String anchorXOffset = null;
    private String anchorYOffset = null;
    private String anchorUnits = null;
    private String anchorIgnoreIfNotPresent = null;
    private String anchorCaseSensitive = null;
    private String anchorMatchWholeWord = null;
    private String anchorHorizontalAlignment = null;
    private String value = null;
    private String selected = null;
    private String tabId = null;
    private String required = null;
    private String locked = null;
    private ErrorDetails errorDetails = null;
    private String tabOrder = null;

    public Radio pageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the page number on which the tab is located.")
    @JsonProperty(value="pageNumber")
    public String getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Radio xPosition(String xPosition) {
        this.xPosition = xPosition;
        return this;
    }

    @ApiModelProperty(example="null", value="This indicates the horizontal offset of the object on the page. DocuSign uses 72 DPI when determining position.")
    @JsonProperty(value="xPosition")
    public String getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(String xPosition) {
        this.xPosition = xPosition;
    }

    public Radio yPosition(String yPosition) {
        this.yPosition = yPosition;
        return this;
    }

    @ApiModelProperty(example="null", value="This indicates the vertical offset of the object on the page. DocuSign uses 72 DPI when determining position.")
    @JsonProperty(value="yPosition")
    public String getYPosition() {
        return this.yPosition;
    }

    public void setYPosition(String yPosition) {
        this.yPosition = yPosition;
    }

    public Radio anchorString(String anchorString) {
        this.anchorString = anchorString;
        return this;
    }

    @ApiModelProperty(example="null", value="Anchor text information for a radio button.")
    @JsonProperty(value="anchorString")
    public String getAnchorString() {
        return this.anchorString;
    }

    public void setAnchorString(String anchorString) {
        this.anchorString = anchorString;
    }

    public Radio anchorXOffset(String anchorXOffset) {
        this.anchorXOffset = anchorXOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the X axis location of the tab, in achorUnits, relative to the anchorString.")
    @JsonProperty(value="anchorXOffset")
    public String getAnchorXOffset() {
        return this.anchorXOffset;
    }

    public void setAnchorXOffset(String anchorXOffset) {
        this.anchorXOffset = anchorXOffset;
    }

    public Radio anchorYOffset(String anchorYOffset) {
        this.anchorYOffset = anchorYOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the Y axis location of the tab, in achorUnits, relative to the anchorString.")
    @JsonProperty(value="anchorYOffset")
    public String getAnchorYOffset() {
        return this.anchorYOffset;
    }

    public void setAnchorYOffset(String anchorYOffset) {
        this.anchorYOffset = anchorYOffset;
    }

    public Radio anchorUnits(String anchorUnits) {
        this.anchorUnits = anchorUnits;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.")
    @JsonProperty(value="anchorUnits")
    public String getAnchorUnits() {
        return this.anchorUnits;
    }

    public void setAnchorUnits(String anchorUnits) {
        this.anchorUnits = anchorUnits;
    }

    public Radio anchorIgnoreIfNotPresent(String anchorIgnoreIfNotPresent) {
        this.anchorIgnoreIfNotPresent = anchorIgnoreIfNotPresent;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, this tab is ignored if anchorString is not found in the document.")
    @JsonProperty(value="anchorIgnoreIfNotPresent")
    public String getAnchorIgnoreIfNotPresent() {
        return this.anchorIgnoreIfNotPresent;
    }

    public void setAnchorIgnoreIfNotPresent(String anchorIgnoreIfNotPresent) {
        this.anchorIgnoreIfNotPresent = anchorIgnoreIfNotPresent;
    }

    public Radio anchorCaseSensitive(String anchorCaseSensitive) {
        this.anchorCaseSensitive = anchorCaseSensitive;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the anchor string does not consider case when matching strings in the document. The default value is **true**.")
    @JsonProperty(value="anchorCaseSensitive")
    public String getAnchorCaseSensitive() {
        return this.anchorCaseSensitive;
    }

    public void setAnchorCaseSensitive(String anchorCaseSensitive) {
        this.anchorCaseSensitive = anchorCaseSensitive;
    }

    public Radio anchorMatchWholeWord(String anchorMatchWholeWord) {
        this.anchorMatchWholeWord = anchorMatchWholeWord;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the anchor string in this tab matches whole words only (strings embedded in other strings are ignored.) The default value is **true**.")
    @JsonProperty(value="anchorMatchWholeWord")
    public String getAnchorMatchWholeWord() {
        return this.anchorMatchWholeWord;
    }

    public void setAnchorMatchWholeWord(String anchorMatchWholeWord) {
        this.anchorMatchWholeWord = anchorMatchWholeWord;
    }

    public Radio anchorHorizontalAlignment(String anchorHorizontalAlignment) {
        this.anchorHorizontalAlignment = anchorHorizontalAlignment;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the alignment of anchor tabs with anchor strings. Possible values are **left** or **right**. The default value is **left**.")
    @JsonProperty(value="anchorHorizontalAlignment")
    public String getAnchorHorizontalAlignment() {
        return this.anchorHorizontalAlignment;
    }

    public void setAnchorHorizontalAlignment(String anchorHorizontalAlignment) {
        this.anchorHorizontalAlignment = anchorHorizontalAlignment;
    }

    public Radio value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the value of the tab. ")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Radio selected(String selected) {
        this.selected = selected;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the radio button is selected.")
    @JsonProperty(value="selected")
    public String getSelected() {
        return this.selected;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public Radio tabId(String tabId) {
        this.tabId = tabId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call]. \n\n \n")
    @JsonProperty(value="tabId")
    public String getTabId() {
        return this.tabId;
    }

    public void setTabId(String tabId) {
        this.tabId = tabId;
    }

    public Radio required(String required) {
        this.required = required;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the signer is required to fill out this tab")
    @JsonProperty(value="required")
    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public Radio locked(String locked) {
        this.locked = locked;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the signer cannot change the data of the custom tab.")
    @JsonProperty(value="locked")
    public String getLocked() {
        return this.locked;
    }

    public void setLocked(String locked) {
        this.locked = locked;
    }

    public Radio errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Radio tabOrder(String tabOrder) {
        this.tabOrder = tabOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="tabOrder")
    public String getTabOrder() {
        return this.tabOrder;
    }

    public void setTabOrder(String tabOrder) {
        this.tabOrder = tabOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Radio radio = (Radio)o;
        return Objects.equals(this.pageNumber, radio.pageNumber) && Objects.equals(this.xPosition, radio.xPosition) && Objects.equals(this.yPosition, radio.yPosition) && Objects.equals(this.anchorString, radio.anchorString) && Objects.equals(this.anchorXOffset, radio.anchorXOffset) && Objects.equals(this.anchorYOffset, radio.anchorYOffset) && Objects.equals(this.anchorUnits, radio.anchorUnits) && Objects.equals(this.anchorIgnoreIfNotPresent, radio.anchorIgnoreIfNotPresent) && Objects.equals(this.anchorCaseSensitive, radio.anchorCaseSensitive) && Objects.equals(this.anchorMatchWholeWord, radio.anchorMatchWholeWord) && Objects.equals(this.anchorHorizontalAlignment, radio.anchorHorizontalAlignment) && Objects.equals(this.value, radio.value) && Objects.equals(this.selected, radio.selected) && Objects.equals(this.tabId, radio.tabId) && Objects.equals(this.required, radio.required) && Objects.equals(this.locked, radio.locked) && Objects.equals(this.errorDetails, radio.errorDetails) && Objects.equals(this.tabOrder, radio.tabOrder);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.xPosition, this.yPosition, this.anchorString, this.anchorXOffset, this.anchorYOffset, this.anchorUnits, this.anchorIgnoreIfNotPresent, this.anchorCaseSensitive, this.anchorMatchWholeWord, this.anchorHorizontalAlignment, this.value, this.selected, this.tabId, this.required, this.locked, this.errorDetails, this.tabOrder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Radio {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    xPosition: ").append(this.toIndentedString(this.xPosition)).append("\n");
        sb.append("    yPosition: ").append(this.toIndentedString(this.yPosition)).append("\n");
        sb.append("    anchorString: ").append(this.toIndentedString(this.anchorString)).append("\n");
        sb.append("    anchorXOffset: ").append(this.toIndentedString(this.anchorXOffset)).append("\n");
        sb.append("    anchorYOffset: ").append(this.toIndentedString(this.anchorYOffset)).append("\n");
        sb.append("    anchorUnits: ").append(this.toIndentedString(this.anchorUnits)).append("\n");
        sb.append("    anchorIgnoreIfNotPresent: ").append(this.toIndentedString(this.anchorIgnoreIfNotPresent)).append("\n");
        sb.append("    anchorCaseSensitive: ").append(this.toIndentedString(this.anchorCaseSensitive)).append("\n");
        sb.append("    anchorMatchWholeWord: ").append(this.toIndentedString(this.anchorMatchWholeWord)).append("\n");
        sb.append("    anchorHorizontalAlignment: ").append(this.toIndentedString(this.anchorHorizontalAlignment)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    selected: ").append(this.toIndentedString(this.selected)).append("\n");
        sb.append("    tabId: ").append(this.toIndentedString(this.tabId)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    tabOrder: ").append(this.toIndentedString(this.tabOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

