/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains information for transfering values between Salesforce data fields and DocuSign Tabs.")
public class MergeField {
    private String configurationType = null;
    private String path = null;
    private String writeBack = null;
    private String allowSenderToEdit = null;
    private String row = null;

    public MergeField configurationType(String configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    @ApiModelProperty(example="null", value="If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
    @JsonProperty(value="configurationType")
    public String getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    public MergeField path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="Sets the object associated with the custom tab. Currently this is the Salesforce Object.")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MergeField writeBack(String writeBack) {
        this.writeBack = writeBack;
        return this;
    }

    @ApiModelProperty(example="null", value="When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.")
    @JsonProperty(value="writeBack")
    public String getWriteBack() {
        return this.writeBack;
    }

    public void setWriteBack(String writeBack) {
        this.writeBack = writeBack;
    }

    public MergeField allowSenderToEdit(String allowSenderToEdit) {
        this.allowSenderToEdit = allowSenderToEdit;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender can modify the value of the custom tab during the sending process.")
    @JsonProperty(value="allowSenderToEdit")
    public String getAllowSenderToEdit() {
        return this.allowSenderToEdit;
    }

    public void setAllowSenderToEdit(String allowSenderToEdit) {
        this.allowSenderToEdit = allowSenderToEdit;
    }

    public MergeField row(String row) {
        this.row = row;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the row number in a Salesforce table that the merge field value corresponds to.")
    @JsonProperty(value="row")
    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeField mergeField = (MergeField)o;
        return Objects.equals(this.configurationType, mergeField.configurationType) && Objects.equals(this.path, mergeField.path) && Objects.equals(this.writeBack, mergeField.writeBack) && Objects.equals(this.allowSenderToEdit, mergeField.allowSenderToEdit) && Objects.equals(this.row, mergeField.row);
    }

    public int hashCode() {
        return Objects.hash(this.configurationType, this.path, this.writeBack, this.allowSenderToEdit, this.row);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MergeField {\n");
        sb.append("    configurationType: ").append(this.toIndentedString(this.configurationType)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    writeBack: ").append(this.toIndentedString(this.writeBack)).append("\n");
        sb.append("    allowSenderToEdit: ").append(this.toIndentedString(this.allowSenderToEdit)).append("\n");
        sb.append("    row: ").append(this.toIndentedString(this.row)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

