/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class LockRequest {
    private String lockedByApp = null;
    private String lockDurationInSeconds = null;
    private String lockType = null;
    private String useScratchPad = null;
    private String templatePassword = null;

    public LockRequest lockedByApp(String lockedByApp) {
        this.lockedByApp = lockedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="A friendly name of the application used to lock the envelope.  Will be used in error messages to the user when lock conflicts occur.")
    @JsonProperty(value="lockedByApp")
    public String getLockedByApp() {
        return this.lockedByApp;
    }

    public void setLockedByApp(String lockedByApp) {
        this.lockedByApp = lockedByApp;
    }

    public LockRequest lockDurationInSeconds(String lockDurationInSeconds) {
        this.lockDurationInSeconds = lockDurationInSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds to lock the envelope for editing.  Must be greater than 0 seconds.")
    @JsonProperty(value="lockDurationInSeconds")
    public String getLockDurationInSeconds() {
        return this.lockDurationInSeconds;
    }

    public void setLockDurationInSeconds(String lockDurationInSeconds) {
        this.lockDurationInSeconds = lockDurationInSeconds;
    }

    public LockRequest lockType(String lockType) {
        this.lockType = lockType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of envelope lock.  Currently \"edit\" is the only supported type.")
    @JsonProperty(value="lockType")
    public String getLockType() {
        return this.lockType;
    }

    public void setLockType(String lockType) {
        this.lockType = lockType;
    }

    public LockRequest useScratchPad(String useScratchPad) {
        this.useScratchPad = useScratchPad;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved for future use.\n\nIndicates whether a scratchpad is used for editing information.\n ")
    @JsonProperty(value="useScratchPad")
    public String getUseScratchPad() {
        return this.useScratchPad;
    }

    public void setUseScratchPad(String useScratchPad) {
        this.useScratchPad = useScratchPad;
    }

    public LockRequest templatePassword(String templatePassword) {
        this.templatePassword = templatePassword;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="templatePassword")
    public String getTemplatePassword() {
        return this.templatePassword;
    }

    public void setTemplatePassword(String templatePassword) {
        this.templatePassword = templatePassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockRequest lockRequest = (LockRequest)o;
        return Objects.equals(this.lockedByApp, lockRequest.lockedByApp) && Objects.equals(this.lockDurationInSeconds, lockRequest.lockDurationInSeconds) && Objects.equals(this.lockType, lockRequest.lockType) && Objects.equals(this.useScratchPad, lockRequest.useScratchPad) && Objects.equals(this.templatePassword, lockRequest.templatePassword);
    }

    public int hashCode() {
        return Objects.hash(this.lockedByApp, this.lockDurationInSeconds, this.lockType, this.useScratchPad, this.templatePassword);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockRequest {\n");
        sb.append("    lockedByApp: ").append(this.toIndentedString(this.lockedByApp)).append("\n");
        sb.append("    lockDurationInSeconds: ").append(this.toIndentedString(this.lockDurationInSeconds)).append("\n");
        sb.append("    lockType: ").append(this.toIndentedString(this.lockType)).append("\n");
        sb.append("    useScratchPad: ").append(this.toIndentedString(this.useScratchPad)).append("\n");
        sb.append("    templatePassword: ").append(this.toIndentedString(this.templatePassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

