/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.OrganizationAccountSettingsImportResponse;
import com.docusign.admin.model.OrganizationImportResponse;
import com.docusign.admin.model.OrganizationImportsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class BulkImportsApi {
    private ApiClient apiClient;

    public BulkImportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkImportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrganizationAccountSettingsImportResponse addBulkAccountSettingsImport(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addBulkAccountSettingsImport");
        }
        if (fileCsv == null) {
            throw new ApiException(400, "Missing the required parameter 'fileCsv' when calling addBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationAccountSettingsImportResponse> localVarReturnType = new GenericType<OrganizationAccountSettingsImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportAddUsersRequest(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportAddUsersRequest");
        }
        if (fileCsv == null) {
            throw new ApiException(400, "Missing the required parameter 'fileCsv' when calling createBulkImportAddUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/add".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportCloseUsersRequest(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportCloseUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/close".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportExternalCloseUsersRequest(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportExternalCloseUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/close_external".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportSingleAccountAddUsersRequest(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportSingleAccountAddUsersRequest");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkImportSingleAccountAddUsersRequest");
        }
        if (fileCsv == null) {
            throw new ApiException(400, "Missing the required parameter 'fileCsv' when calling createBulkImportSingleAccountAddUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/imports/bulk_users/add".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportSingleAccountUpdateUsersRequest(UUID organizationId, UUID accountId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportSingleAccountUpdateUsersRequest");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkImportSingleAccountUpdateUsersRequest");
        }
        if (fileCsv == null) {
            throw new ApiException(400, "Missing the required parameter 'fileCsv' when calling createBulkImportSingleAccountUpdateUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/imports/bulk_users/update".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse createBulkImportUpdateUsersRequest(UUID organizationId, byte[] fileCsv) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createBulkImportUpdateUsersRequest");
        }
        if (fileCsv == null) {
            throw new ApiException(400, "Missing the required parameter 'fileCsv' when calling createBulkImportUpdateUsersRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/update".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileCsv != null) {
            localVarFormParams.put("file.csv", fileCsv);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteBulkAccountSettingsImport(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteBulkAccountSettingsImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling deleteBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteBulkUserImport(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteBulkUserImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling deleteBulkUserImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationAccountSettingsImportResponse getBulkAccountSettingsImport(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkAccountSettingsImport");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkAccountSettingsImport");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationAccountSettingsImportResponse> localVarReturnType = new GenericType<OrganizationAccountSettingsImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OrganizationAccountSettingsImportResponse> getBulkAccountSettingsImports(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkAccountSettingsImports");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/account_settings".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<List<OrganizationAccountSettingsImportResponse>> localVarReturnType = new GenericType<List<OrganizationAccountSettingsImportResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object getBulkUserImportCSV(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportCSV");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkUserImportCSV");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}/results_csv".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportResponse getBulkUserImportRequest(UUID organizationId, UUID importId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportRequest");
        }
        if (importId == null) {
            throw new ApiException(400, "Missing the required parameter 'importId' when calling getBulkUserImportRequest");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users/{importId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{importId\\}", this.apiClient.escapeString(importId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportResponse> localVarReturnType = new GenericType<OrganizationImportResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationImportsResponse getBulkUserImportRequests(UUID organizationId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getBulkUserImportRequests");
        }
        String localVarPath = "/v2/organizations/{organizationId}/imports/bulk_users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationImportsResponse> localVarReturnType = new GenericType<OrganizationImportsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

