/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

class OutputStreamToInputStreamConsumer
implements IInputStreamConsumer {
    private final OutputStream outputStream;
    private final AtomicBoolean closeMark;

    public OutputStreamToInputStreamConsumer(OutputStream outputStream, boolean closeStream) {
        this.outputStream = outputStream;
        this.closeMark = new AtomicBoolean(!closeStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(InputStream inputStream) {
        try {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)this.outputStream);
        }
        catch (IOException e) {
            throw new FileSystemInteractionException("Could not write result to output stream", (Throwable)e);
        }
        finally {
            try {
                this.closeStreamIfApplicable();
            }
            finally {
                try {
                    Closeables.close((Closeable)inputStream, (boolean)true);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)"Guava's Closeables#close threw an exception that should be suppressed");
                }
            }
        }
    }

    public void onCancel() {
        this.closeStreamIfApplicable();
    }

    public void onException(Exception e) {
        this.closeStreamIfApplicable();
    }

    private void closeStreamIfApplicable() {
        if (this.closeMark.compareAndSet(false, true)) {
            try {
                Closeables.close((Closeable)this.outputStream, (boolean)false);
            }
            catch (IOException e) {
                throw new FileSystemInteractionException("Could not close output stream", (Throwable)e);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(OutputStreamToInputStreamConsumer.class).add("outputStream", (Object)this.outputStream).add("closeMark", this.closeMark.get()).toString();
    }
}

