/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IFileSource;
import com.documents4j.conversion.IConversionManager;
import com.documents4j.job.AbstractFutureWrappingPriorityFuture;
import com.documents4j.job.LocalConversionContext;
import com.google.common.base.Objects;
import java.io.File;

class LocalFutureWrappingPriorityFuture
extends AbstractFutureWrappingPriorityFuture<File, LocalConversionContext> {
    private final IFileSource source;
    private final DocumentType sourceFormat;
    private final File target;
    private final IFileConsumer callback;
    private final DocumentType targetFormat;
    private final IConversionManager conversionManager;

    LocalFutureWrappingPriorityFuture(IConversionManager conversionManager, IFileSource source, DocumentType sourceFormat, File target, IFileConsumer callback, DocumentType targetFormat, int priority) {
        super(priority);
        this.conversionManager = conversionManager;
        this.source = source;
        this.sourceFormat = sourceFormat;
        this.target = target;
        this.callback = callback;
        this.targetFormat = targetFormat;
    }

    protected File fetchSource() {
        return this.source.getFile();
    }

    protected void onSourceConsumed(File fetchedSource) {
        this.source.onConsumed(fetchedSource);
    }

    protected LocalConversionContext startConversion(File fetchedSource) {
        return new LocalConversionContext(this.conversionManager.startConversion(fetchedSource, this.sourceFormat, this.target, this.targetFormat));
    }

    protected void onConversionFinished(LocalConversionContext conversionContext) {
        this.callback.onComplete(this.target);
    }

    protected void onConversionCancelled() {
        this.callback.onCancel(this.target);
    }

    protected void onConversionFailed(RuntimeException e) {
        this.callback.onException(this.target, (Exception)e);
    }

    public String toString() {
        return Objects.toStringHelper((String)"LocalConversion").add("pending", this.getPendingCondition().getCount() != 0L).add("cancelled", this.isCancelled()).add("done", this.isDone()).add("priority", (Object)this.getPriority()).add("file-system-target", (Object)this.target).toString();
    }
}

