/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.job.AbstractFutureWrappingPriorityFuture;
import com.documents4j.job.ConsumeOnCloseInputStream;
import com.documents4j.job.RemoteConversionContext;
import com.google.common.base.MoreObjects;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

class RemoteFutureWrappingPriorityFuture
extends AbstractFutureWrappingPriorityFuture<InputStream, RemoteConversionContext> {
    private final WebTarget webTarget;
    private final IInputStreamSource source;
    private final DocumentType sourceFormat;
    private final IInputStreamConsumer consumer;
    private final DocumentType targetFormat;
    private final AtomicBoolean consumptionMark;

    RemoteFutureWrappingPriorityFuture(WebTarget webTarget, IInputStreamSource source, DocumentType sourceFormat, IInputStreamConsumer consumer, DocumentType targetFormat, int priority) {
        super(priority);
        this.webTarget = webTarget;
        this.source = source;
        this.sourceFormat = sourceFormat;
        this.consumer = consumer;
        this.targetFormat = targetFormat;
        this.consumptionMark = new AtomicBoolean(false);
    }

    protected InputStream fetchSource() {
        return this.source.getInputStream();
    }

    protected void onSourceConsumed(InputStream fetchedSource) {
        if (this.consumptionMark.compareAndSet(false, true)) {
            this.source.onConsumed(fetchedSource);
        }
    }

    protected RemoteConversionContext startConversion(InputStream fetchedSource) {
        return new RemoteConversionContext(this.webTarget.path("/").request(new String[]{this.targetFormat.toString()}).header("Converter-Job-Priority", (Object)this.getPriority().getValue()).async().post(Entity.entity((Object)new ConsumeOnCloseInputStream(this, fetchedSource), (String)this.sourceFormat.toString())));
    }

    protected void onConversionFinished(RemoteConversionContext conversionContext) throws Exception {
        Response response = conversionContext.getWebResponse().get();
        try {
            this.consumer.onComplete((InputStream)response.readEntity(InputStream.class));
        }
        finally {
            response.close();
        }
    }

    protected void onConversionFailed(RuntimeException e) {
        this.consumer.onException((Exception)e);
    }

    protected void onConversionCancelled() {
        this.consumer.onCancel();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RemoteConversion").add("pending", this.getPendingCondition().getCount() != 0L).add("cancelled", this.isCancelled()).add("done", this.isDone()).add("priority", (Object)this.getPriority()).add("web-target", (Object)this.webTarget.getUri()).toString();
    }
}

