/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONPointerException;
import org.json.JSONTokener;

public class JSONPointer {
    private final Supplier<JSONObject> documentProvider;
    private final String fragment;

    private static JSONObject executeWith(SchemaClient client, String url) {
        String resp = null;
        BufferedReader buffReader = null;
        InputStreamReader reader = null;
        try {
            String line;
            InputStream responseStream = client.get(url);
            reader = new InputStreamReader(responseStream, Charset.defaultCharset());
            buffReader = new BufferedReader(reader);
            StringBuilder strBuilder = new StringBuilder();
            while ((line = buffReader.readLine()) != null) {
                strBuilder.append(line);
            }
            resp = strBuilder.toString();
            JSONObject jSONObject = new JSONObject(new JSONTokener(resp));
            return jSONObject;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (JSONException e) {
            throw new SchemaException("failed to parse " + resp, e);
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static final JSONPointer forDocument(JSONObject document, String fragment) {
        return new JSONPointer((Supplier<JSONObject>)Suppliers.ofInstance((Object)document), fragment);
    }

    public static final JSONPointer forURL(final SchemaClient schemaClient, String url) {
        String fragment;
        String toBeQueried;
        int poundIdx = url.indexOf(35);
        if (poundIdx == -1) {
            toBeQueried = url;
            fragment = "";
        } else {
            fragment = url.substring(poundIdx);
            toBeQueried = url.substring(0, poundIdx);
        }
        return new JSONPointer(new Supplier<JSONObject>(){

            public JSONObject get() {
                return JSONPointer.executeWith(schemaClient, toBeQueried);
            }
        }, fragment);
    }

    public JSONPointer(Supplier<JSONObject> documentProvider, String fragment) {
        this.documentProvider = documentProvider;
        this.fragment = fragment;
    }

    public QueryResult query() {
        JSONObject document = (JSONObject)this.documentProvider.get();
        if (this.fragment.isEmpty()) {
            return new QueryResult(document, document);
        }
        String[] path = this.fragment.split("/");
        if (path[0] == null || !path[0].startsWith("#")) {
            throw new IllegalArgumentException("JSON pointers must start with a '#'");
        }
        try {
            JSONObject result = this.queryFrom(document);
            return new QueryResult(document, result);
        }
        catch (JSONPointerException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    private JSONObject queryFrom(JSONObject document) {
        JSONObject result = "#".equals(this.fragment) ? document : (JSONObject)new org.json.JSONPointer(this.fragment).queryFrom((Object)document);
        if (result == null) {
            throw new JSONPointerException(String.format("could not query schema document by pointer [%s]", this.fragment));
        }
        return result;
    }

    public static class QueryResult {
        private final JSONObject containingDocument;
        private final JSONObject queryResult;

        public QueryResult(JSONObject containingDocument, JSONObject queryResult) {
            this.containingDocument = Objects.requireNonNull(containingDocument, "containingDocument cannot be null");
            this.queryResult = Objects.requireNonNull(queryResult, "queryResult cannot be null");
        }

        public JSONObject getContainingDocument() {
            return this.containingDocument;
        }

        public JSONObject getQueryResult() {
            return this.queryResult;
        }
    }
}

