/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import com.google.common.base.Optional;
import java.util.Objects;
import org.everit.json.schema.Consumer;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.loader.LoadingState;

public class StringSchemaLoader {
    private LoadingState ls;

    public StringSchemaLoader(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
    }

    public StringSchema.Builder load() {
        final StringSchema.Builder builder = StringSchema.builder();
        this.ls.ifPresent("minLength", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.minLength(integer);
            }
        });
        this.ls.ifPresent("maxLength", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.maxLength(integer);
            }
        });
        this.ls.ifPresent("pattern", String.class, new Consumer<String>(){

            @Override
            public void accept(String s) {
                builder.pattern(s);
            }
        });
        this.ls.ifPresent("format", String.class, new Consumer<String>(){

            @Override
            public void accept(String s) {
                Optional<FormatValidator> validator = StringSchemaLoader.this.ls.getFormatValidator(s);
                if (validator.isPresent()) {
                    builder.formatValidator((FormatValidator)validator.get());
                }
            }
        });
        return builder;
    }
}

