/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Objects;
import org.everit.json.schema.Consumer;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class ObjectSchemaLoader {
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public ObjectSchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ObjectSchema.Builder load() {
        JSONObject patternPropsJson;
        String[] patterns;
        final ObjectSchema.Builder builder = ObjectSchema.builder();
        this.ls.ifPresent("minProperties", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.minProperties(integer);
            }
        });
        this.ls.ifPresent("maxProperties", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.maxProperties(integer);
            }
        });
        if (this.ls.schemaJson.has("properties")) {
            this.ls.typeMultiplexer(this.ls.schemaJson.get("properties")).ifObject().then(new Consumer<JSONObject>(){

                @Override
                public void accept(JSONObject propertyDefs) {
                    ObjectSchemaLoader.this.populatePropertySchemas(propertyDefs, builder);
                }
            }).requireAny();
        }
        if (this.ls.schemaJson.has("additionalProperties")) {
            this.ls.typeMultiplexer("additionalProperties", this.ls.schemaJson.get("additionalProperties")).ifIs(Boolean.class).then(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean aBoolean) {
                    builder.additionalProperties(aBoolean);
                }
            }).ifObject().then(new Consumer<JSONObject>(){

                @Override
                public void accept(JSONObject def) {
                    builder.schemaOfAdditionalProperties((Schema)ObjectSchemaLoader.this.defaultLoader.loadChild(def).build());
                }
            }).requireAny();
        }
        if (this.ls.schemaJson.has("required")) {
            JSONArray requiredJson = this.ls.schemaJson.getJSONArray("required");
            for (int i = 0; i < requiredJson.length(); ++i) {
                builder.addRequiredProperty(requiredJson.getString(i));
            }
        }
        if (this.ls.schemaJson.has("patternProperties") && (patterns = JSONObject.getNames((JSONObject)(patternPropsJson = this.ls.schemaJson.getJSONObject("patternProperties")))) != null) {
            for (String pattern : patterns) {
                builder.patternProperty(pattern, (Schema)this.defaultLoader.loadChild(patternPropsJson.getJSONObject(pattern)).build());
            }
        }
        this.ls.ifPresent("dependencies", JSONObject.class, new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject deps) {
                ObjectSchemaLoader.this.addDependencies(builder, deps);
            }
        });
        return builder;
    }

    private void populatePropertySchemas(JSONObject propertyDefs, ObjectSchema.Builder builder) {
        String[] names = JSONObject.getNames((JSONObject)propertyDefs);
        if (names == null || names.length == 0) {
            return;
        }
        for (String key : names) {
            this.addPropertySchemaDefinition(key, propertyDefs.get(key), builder);
        }
    }

    private void addPropertySchemaDefinition(final String keyOfObj, Object definition, final ObjectSchema.Builder builder) {
        this.ls.typeMultiplexer(definition).ifObject().then(new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject obj) {
                builder.addPropertySchema(keyOfObj, (Schema)ObjectSchemaLoader.this.defaultLoader.loadChild(obj).build());
            }
        }).requireAny();
    }

    private void addDependencies(ObjectSchema.Builder builder, JSONObject deps) {
        for (String name : JSONObject.getNames((JSONObject)deps)) {
            this.addDependency(builder, name, deps.get(name));
        }
    }

    private void addDependency(final ObjectSchema.Builder builder, final String ifPresent, Object deps) {
        this.ls.typeMultiplexer(deps).ifObject().then(new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject obj) {
                builder.schemaDependency(ifPresent, (Schema)ObjectSchemaLoader.this.defaultLoader.loadChild(obj).build());
            }
        }).ifIs(JSONArray.class).then(new Consumer<JSONArray>(){

            @Override
            public void accept(JSONArray propNames) {
                for (int i = 0; i < propNames.length(); ++i) {
                    builder.propertyDependency(ifPresent, propNames.getString(i));
                }
            }
        }).requireAny();
    }
}

