/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Consumer;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class ArraySchemaLoader {
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public ArraySchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ArraySchema.Builder load() {
        final ArraySchema.Builder builder = ArraySchema.builder();
        this.ls.ifPresent("minItems", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.minItems(integer);
            }
        });
        this.ls.ifPresent("maxItems", Integer.class, new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                builder.maxItems(integer);
            }
        });
        this.ls.ifPresent("uniqueItems", Boolean.class, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean aBoolean) {
                builder.uniqueItems(aBoolean);
            }
        });
        if (this.ls.schemaJson.has("additionalItems")) {
            this.ls.typeMultiplexer("additionalItems", this.ls.schemaJson.get("additionalItems")).ifIs(Boolean.class).then(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean aBoolean) {
                    builder.additionalItems(aBoolean);
                }
            }).ifObject().then(new Consumer<JSONObject>(){

                @Override
                public void accept(JSONObject jsonObj) {
                    builder.schemaOfAdditionalItems((Schema)ArraySchemaLoader.this.defaultLoader.loadChild(jsonObj).build());
                }
            }).requireAny();
        }
        if (this.ls.schemaJson.has("items")) {
            this.ls.typeMultiplexer("items", this.ls.schemaJson.get("items")).ifObject().then(new Consumer<JSONObject>(){

                @Override
                public void accept(JSONObject itemSchema) {
                    builder.allItemSchema((Schema)ArraySchemaLoader.this.defaultLoader.loadChild(itemSchema).build());
                }
            }).ifIs(JSONArray.class).then(new Consumer<JSONArray>(){

                @Override
                public void accept(JSONArray arr) {
                    ArraySchemaLoader.this.buildTupleSchema(builder, arr);
                }
            }).requireAny();
        }
        return builder;
    }

    private void buildTupleSchema(final ArraySchema.Builder builder, JSONArray itemSchema) {
        for (int i = 0; i < itemSchema.length(); ++i) {
            this.ls.typeMultiplexer(itemSchema.get(i)).ifObject().then(new Consumer<JSONObject>(){

                @Override
                public void accept(JSONObject schema) {
                    builder.addItemSchema((Schema)ArraySchemaLoader.this.defaultLoader.loadChild(schema).build());
                }
            }).requireAny();
        }
    }
}

