/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.everit.json.schema.AbstractFormatValidator;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class DateTimeFormatValidator
extends AbstractFormatValidator {
    private static final List<String> FORMATS_ACCEPTED = ImmutableList.of((Object)"yyyy-MM-dd'T'HH:mm:ssZ", (Object)"yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,9}Z");
    private static final String PARTIAL_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ZONE_OFFSET_PATTERN = "XXX";
    private static final DateTimeFormatter FORMATTER;

    @Override
    public Optional<String> validate(String subject) {
        try {
            FORMATTER.parse((CharSequence)subject);
            return Optional.absent();
        }
        catch (DateTimeParseException e) {
            return Optional.of((Object)String.format("[%s] is not a valid date-time. Expected %s", subject, FORMATS_ACCEPTED));
        }
    }

    @Override
    public String formatName() {
        return "date-time";
    }

    static {
        DateTimeFormatter secondsFractionFormatter = new DateTimeFormatterBuilder().appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern(PARTIAL_DATETIME_PATTERN).appendOptional(secondsFractionFormatter).appendPattern(ZONE_OFFSET_PATTERN);
        FORMATTER = builder.toFormatter();
    }
}

