/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Consumer;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.internal.DateTimeFormatValidator;
import org.everit.json.schema.internal.EmailFormatValidator;
import org.everit.json.schema.internal.HostnameFormatValidator;
import org.everit.json.schema.internal.IPV4Validator;
import org.everit.json.schema.internal.IPV6Validator;
import org.everit.json.schema.internal.URIFormatValidator;
import org.everit.json.schema.loader.ArraySchemaLoader;
import org.everit.json.schema.loader.CombinedSchemaLoader;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.ObjectSchemaLoader;
import org.everit.json.schema.loader.ReferenceLookup;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.StringSchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.WrappingFormatValidator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SchemaLoader {
    private static final List<String> ARRAY_SCHEMA_PROPS = Arrays.asList("items", "additionalItems", "minItems", "maxItems", "uniqueItems");
    private static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "minimumExclusive", "maximumExclusive", "multipleOf");
    private static final List<String> OBJECT_SCHEMA_PROPS = Arrays.asList("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties");
    private static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    private final LoadingState ls;

    public static SchemaLoaderBuilder builder() {
        return new SchemaLoaderBuilder();
    }

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient httpClient) {
        SchemaLoader loader = SchemaLoader.builder().schemaJson(schemaJson).httpClient(httpClient).build();
        return loader.load().build();
    }

    public SchemaLoader(SchemaLoaderBuilder builder) {
        URI id = builder.id;
        if (id == null && builder.schemaJson.has("id")) {
            try {
                id = new URI(builder.schemaJson.getString("id"));
            }
            catch (URISyntaxException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        this.ls = new LoadingState(builder.httpClient, builder.formatValidators, builder.pointerSchemas, builder.getRootSchemaJson(), builder.schemaJson, id);
    }

    @Deprecated
    SchemaLoader(String id, JSONObject schemaJson, JSONObject rootSchemaJson, Map<String, ReferenceSchema.Builder> pointerSchemas, SchemaClient httpClient) {
        this(SchemaLoader.builder().schemaJson(schemaJson).rootSchemaJson(rootSchemaJson).resolutionScope(id).httpClient(httpClient).pointerSchemas(pointerSchemas));
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JSONArray subtypeJsons = this.ls.schemaJson.getJSONArray("type");
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        for (int i = 0; i < subtypeJsons.length(); ++i) {
            String subtypeJson = subtypeJsons.getString(i);
            Schema.Builder<?> schemaBuilder = this.loadForExplicitType(subtypeJson);
            subschemas.add((Schema)schemaBuilder.build());
        }
        return CombinedSchema.anyOf(subschemas);
    }

    private EnumSchema.Builder buildEnumSchema() {
        JSONArray arr = this.ls.schemaJson.getJSONArray("enum");
        HashSet possibleValues = Sets.newHashSet((Iterator)arr.iterator());
        return EnumSchema.builder().possibleValues(possibleValues);
    }

    private NotSchema.Builder buildNotSchema() {
        Object mustNotMatch = this.loadChild(this.ls.schemaJson.getJSONObject("not")).build();
        return NotSchema.builder().mustNotMatch((Schema)mustNotMatch);
    }

    private Schema.Builder<?> buildSchemaWithoutExplicitType() {
        if (this.ls.schemaJson.length() == 0) {
            return EmptySchema.builder();
        }
        if (this.ls.schemaJson.has("$ref")) {
            return new ReferenceLookup(this.ls).lookup(this.ls.schemaJson.getString("$ref"), this.ls.schemaJson);
        }
        Schema.Builder<?> rval = this.sniffSchemaByProps();
        if (rval != null) {
            return rval;
        }
        if (this.ls.schemaJson.has("not")) {
            return this.buildNotSchema();
        }
        return EmptySchema.builder();
    }

    private NumberSchema.Builder buildNumberSchema() {
        final NumberSchema.Builder builder = NumberSchema.builder();
        this.ls.ifPresent("minimum", Number.class, new Consumer<Number>(){

            @Override
            public void accept(Number number) {
                builder.minimum(number);
            }
        });
        this.ls.ifPresent("maximum", Number.class, new Consumer<Number>(){

            @Override
            public void accept(Number number) {
                builder.maximum(number);
            }
        });
        this.ls.ifPresent("multipleOf", Number.class, new Consumer<Number>(){

            @Override
            public void accept(Number number) {
                builder.multipleOf(number);
            }
        });
        this.ls.ifPresent("exclusiveMinimum", Boolean.class, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean bool) {
                builder.exclusiveMinimum(bool);
            }
        });
        this.ls.ifPresent("exclusiveMaximum", Boolean.class, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean bool) {
                builder.exclusiveMaximum(bool);
            }
        });
        return builder;
    }

    public Schema.Builder<?> load() {
        final Schema.Builder builder = this.ls.schemaJson.has("enum") ? this.buildEnumSchema() : (Schema.Builder)new CombinedSchemaLoader(this.ls, this).load().or(new Supplier(){

            public Object get() {
                if (!((SchemaLoader)SchemaLoader.this).ls.schemaJson.has("type") || ((SchemaLoader)SchemaLoader.this).ls.schemaJson.has("$ref")) {
                    return SchemaLoader.this.buildSchemaWithoutExplicitType();
                }
                return SchemaLoader.this.loadForType(((SchemaLoader)SchemaLoader.this).ls.schemaJson.get("type"));
            }
        });
        this.ls.ifPresent("id", String.class, new Consumer<String>(){

            @Override
            public void accept(String s) {
                builder.id(s);
            }
        });
        this.ls.ifPresent("title", String.class, new Consumer<String>(){

            @Override
            public void accept(String s) {
                builder.title(s);
            }
        });
        this.ls.ifPresent("description", String.class, new Consumer<String>(){

            @Override
            public void accept(String s) {
                builder.description(s);
            }
        });
        return builder;
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        switch (typeString) {
            case "string": {
                return new StringSchemaLoader(this.ls).load();
            }
            case "integer": {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case "number": {
                return this.buildNumberSchema();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return this.buildArraySchema();
            }
            case "object": {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(String.format("unknown type: [%s]", typeString));
    }

    private ObjectSchema.Builder buildObjectSchema() {
        return new ObjectSchemaLoader(this.ls, this).load();
    }

    private ArraySchema.Builder buildArraySchema() {
        return new ArraySchemaLoader(this.ls, this).load();
    }

    Schema.Builder<?> loadForType(Object type) {
        if (type instanceof JSONArray) {
            return this.buildAnyOfSchemaForMultipleTypes();
        }
        if (type instanceof String) {
            return this.loadForExplicitType((String)type);
        }
        throw new SchemaException("type", Arrays.asList(JSONArray.class, String.class), type);
    }

    private boolean schemaHasAnyOf(Collection<String> propNames) {
        return FluentIterable.from(propNames).firstMatch((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return ((SchemaLoader)SchemaLoader.this).ls.schemaJson.has(input);
            }
        }).isPresent();
    }

    Schema.Builder<?> loadChild(JSONObject childJson) {
        return this.ls.initChildLoader().schemaJson(childJson).build().load();
    }

    Schema.Builder<?> sniffSchemaByProps() {
        if (this.schemaHasAnyOf(ARRAY_SCHEMA_PROPS)) {
            return this.buildArraySchema().requiresArray(false);
        }
        if (this.schemaHasAnyOf(OBJECT_SCHEMA_PROPS)) {
            return this.buildObjectSchema().requiresObject(false);
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            return this.buildNumberSchema().requiresNumber(false);
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            return new StringSchemaLoader(this.ls).load().requiresString(false);
        }
        return null;
    }

    @Deprecated
    Optional<FormatValidator> getFormatValidator(String formatName) {
        return this.ls.getFormatValidator(formatName);
    }

    public static class SchemaLoaderBuilder {
        SchemaClient httpClient = new DefaultSchemaClient();
        JSONObject schemaJson;
        JSONObject rootSchemaJson;
        Map<String, ReferenceSchema.Builder> pointerSchemas = new HashMap<String, ReferenceSchema.Builder>();
        URI id;
        Map<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>();

        public SchemaLoaderBuilder() {
            this.formatValidators.put("date-time", new DateTimeFormatValidator());
            this.formatValidators.put("uri", new URIFormatValidator());
            this.formatValidators.put("email", new EmailFormatValidator());
            this.formatValidators.put("ipv4", new IPV4Validator());
            this.formatValidators.put("ipv6", new IPV6Validator());
            this.formatValidators.put("hostname", new HostnameFormatValidator());
        }

        public SchemaLoaderBuilder addFormatValidator(FormatValidator formatValidator) {
            this.formatValidators.put(formatValidator.formatName(), formatValidator);
            return this;
        }

        @Deprecated
        public SchemaLoaderBuilder addFormatValidator(String formatName, FormatValidator formatValidator) {
            if (!Objects.equals(formatName, formatValidator.formatName())) {
                this.formatValidators.put(formatName, new WrappingFormatValidator(formatName, formatValidator));
            } else {
                this.formatValidators.put(formatName, formatValidator);
            }
            return this;
        }

        public SchemaLoader build() {
            return new SchemaLoader(this);
        }

        public JSONObject getRootSchemaJson() {
            return this.rootSchemaJson == null ? this.schemaJson : this.rootSchemaJson;
        }

        public SchemaLoaderBuilder httpClient(SchemaClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SchemaLoaderBuilder resolutionScope(String id) {
            try {
                return this.resolutionScope(new URI(id));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public SchemaLoaderBuilder resolutionScope(URI id) {
            this.id = id;
            return this;
        }

        SchemaLoaderBuilder pointerSchemas(Map<String, ReferenceSchema.Builder> pointerSchemas) {
            this.pointerSchemas = pointerSchemas;
            return this;
        }

        SchemaLoaderBuilder rootSchemaJson(JSONObject rootSchemaJson) {
            this.rootSchemaJson = rootSchemaJson;
            return this;
        }

        public SchemaLoaderBuilder schemaJson(JSONObject schemaJson) {
            this.schemaJson = schemaJson;
            return this;
        }

        SchemaLoaderBuilder formatValidators(Map<String, FormatValidator> formatValidators) {
            this.formatValidators = formatValidators;
            return this;
        }
    }
}

