/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.Consumer;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.ResolutionScopeChangeListener;
import org.everit.json.schema.loader.internal.TypeBasedMultiplexer;
import org.json.JSONObject;
import org.json.JSONPointer;

class LoadingState {
    final SchemaClient httpClient;
    final Map<String, FormatValidator> formatValidators;
    URI id = null;
    JSONPointer pointerToCurrentObj;
    final Map<String, ReferenceSchema.Builder> pointerSchemas;
    final JSONObject rootSchemaJson;
    final JSONObject schemaJson;

    LoadingState(SchemaClient httpClient, Map<String, FormatValidator> formatValidators, Map<String, ReferenceSchema.Builder> pointerSchemas, JSONObject rootSchemaJson, JSONObject schemaJson, URI id) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient cannot be null");
        this.formatValidators = Objects.requireNonNull(formatValidators, "formatValidators cannot be null");
        this.pointerSchemas = Objects.requireNonNull(pointerSchemas, "pointerSchemas cannot be null");
        this.rootSchemaJson = Objects.requireNonNull(rootSchemaJson, "rootSchemaJson cannot be null");
        this.schemaJson = Objects.requireNonNull(schemaJson, "schemaJson cannot be null");
        this.id = id;
    }

    <E> void ifPresent(String key, Class<E> expectedType, Consumer<E> consumer) {
        if (this.schemaJson.has(key)) {
            Object value = this.schemaJson.get(key);
            try {
                consumer.accept(value);
            }
            catch (ClassCastException e) {
                throw new SchemaException(key, expectedType, value);
            }
        }
    }

    SchemaLoader.SchemaLoaderBuilder initChildLoader() {
        return SchemaLoader.builder().resolutionScope(this.id).schemaJson(this.schemaJson).rootSchemaJson(this.rootSchemaJson).pointerSchemas(this.pointerSchemas).httpClient(this.httpClient).formatValidators(this.formatValidators);
    }

    TypeBasedMultiplexer typeMultiplexer(Object obj) {
        return this.typeMultiplexer(null, obj);
    }

    TypeBasedMultiplexer typeMultiplexer(String keyOfObj, Object obj) {
        TypeBasedMultiplexer multiplexer = new TypeBasedMultiplexer(keyOfObj, obj, this.id);
        multiplexer.addResolutionScopeChangeListener(new ResolutionScopeChangeListener(){

            @Override
            public void resolutionScopeChanged(URI scope) {
                LoadingState.this.id = scope;
            }
        });
        return multiplexer;
    }

    Optional<FormatValidator> getFormatValidator(String format) {
        return Optional.fromNullable((Object)this.formatValidators.get(format));
    }
}

