/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class CombinedSchemaLoader {
    private static final Map<String, CombinedSchemaProvider> COMB_SCHEMA_PROVIDERS = new HashMap<String, CombinedSchemaProvider>(3);
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public CombinedSchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    public Optional<? extends Schema.Builder<?>> load() {
        ImmutableList presentKeys = FluentIterable.from(COMB_SCHEMA_PROVIDERS.keySet()).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return ((CombinedSchemaLoader)CombinedSchemaLoader.this).ls.schemaJson.has(input);
            }
        }).toList();
        if (presentKeys.size() > 1) {
            throw new SchemaException(String.format("expected at most 1 of 'allOf', 'anyOf', 'oneOf', %d found", presentKeys.size()));
        }
        if (presentKeys.size() == 1) {
            String key = (String)presentKeys.get(0);
            JSONArray subschemaDefs = this.ls.schemaJson.getJSONArray(key);
            ArrayList subschemas = Lists.newArrayList();
            for (int i = 0; i < subschemaDefs.length(); ++i) {
                JSONObject defObject = subschemaDefs.getJSONObject(i);
                subschemas.add(this.defaultLoader.loadChild(defObject).build());
            }
            CombinedSchema.Builder combinedSchema = (CombinedSchema.Builder)COMB_SCHEMA_PROVIDERS.get(key).apply(subschemas);
            Schema.Builder<?> baseSchema = this.ls.schemaJson.has("type") ? this.defaultLoader.loadForType(this.ls.schemaJson.get("type")) : this.defaultLoader.sniffSchemaByProps();
            if (baseSchema == null) {
                return Optional.of((Object)combinedSchema);
            }
            return Optional.of((Object)CombinedSchema.allOf(Arrays.asList(baseSchema.build(), combinedSchema.build())));
        }
        return Optional.absent();
    }

    static {
        COMB_SCHEMA_PROVIDERS.put("allOf", new CombinedSchemaProvider(){

            public CombinedSchema.Builder apply(Collection<Schema> input) {
                return CombinedSchema.allOf(input);
            }
        });
        COMB_SCHEMA_PROVIDERS.put("anyOf", new CombinedSchemaProvider(){

            public CombinedSchema.Builder apply(Collection<Schema> input) {
                return CombinedSchema.anyOf(input);
            }
        });
        COMB_SCHEMA_PROVIDERS.put("oneOf", new CombinedSchemaProvider(){

            public CombinedSchema.Builder apply(Collection<Schema> input) {
                return CombinedSchema.oneOf(input);
            }
        });
    }

    private static interface CombinedSchemaProvider
    extends Function<Collection<Schema>, CombinedSchema.Builder> {
    }
}

