/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONObject;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Pattern, Schema> patternProperties;

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = ObjectSchema.copyMap(builder.propertyDependencies);
        this.schemaDependencies = ObjectSchema.copyMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = ObjectSchema.copyMap(builder.patternProperties);
    }

    private FluentIterable<String> getAdditionalProperties(JSONObject subject) {
        Object[] names = JSONObject.getNames((JSONObject)subject);
        if (names == null) {
            return FluentIterable.from((Iterable)Lists.newArrayList());
        }
        return FluentIterable.of((Object[])names).filter((Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !ObjectSchema.this.propertySchemas.containsKey(key) && !ObjectSchema.this.matchesAnyPattern(key);
            }
        });
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Map<Pattern, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        try {
            schema.validate(input);
            return Optional.absent();
        }
        catch (ValidationException e) {
            return Optional.of((Object)e);
        }
    }

    private boolean matchesAnyPattern(final String key) {
        return FluentIterable.from(this.patternProperties.keySet()).firstMatch((Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern pattern) {
                return pattern.matcher(key).find();
            }
        }).isPresent();
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    private ImmutableList<ValidationException> testAdditionalProperties(JSONObject subject) {
        if (!this.additionalProperties) {
            return this.getAdditionalProperties(subject).transform((Function)new Function<String, ValidationException>(){

                public ValidationException apply(String unneeded) {
                    return new ValidationException((Schema)ObjectSchema.this, String.format("extraneous key [%s] is not permitted", unneeded), "additionalProperties");
                }
            }).toList();
        }
        if (this.schemaOfAdditionalProperties != null) {
            ImmutableList additionalPropNames = this.getAdditionalProperties(subject).toList();
            ArrayList rval = new ArrayList();
            for (final String propName : additionalPropNames) {
                Object propVal = subject.get(propName);
                rval.addAll(this.ifFails(this.schemaOfAdditionalProperties, propVal).transform((Function)new Function<ValidationException, ValidationException>(){

                    public ValidationException apply(ValidationException failure) {
                        return failure.prepend(propName, ObjectSchema.this);
                    }
                }).asSet());
            }
            return ImmutableList.copyOf(rval);
        }
        return ImmutableList.of();
    }

    private List<ValidationException> testPatternProperties(JSONObject subject) {
        String[] propNames = JSONObject.getNames((JSONObject)subject);
        if (propNames == null || propNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        for (Map.Entry<Pattern, Schema> entry : this.patternProperties.entrySet()) {
            for (final String propName : propNames) {
                if (!entry.getKey().matcher(propName).find()) continue;
                rval.addAll(this.ifFails(entry.getValue(), subject.get(propName)).transform((Function)new Function<ValidationException, ValidationException>(){

                    public ValidationException apply(ValidationException exc) {
                        return exc.prepend(propName);
                    }
                }).asSet());
            }
        }
        return rval;
    }

    private List<ValidationException> testProperties(JSONObject subject) {
        if (this.propertySchemas != null) {
            ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
            for (Map.Entry<String, Schema> entry : this.propertySchemas.entrySet()) {
                final String key = entry.getKey();
                if (!subject.has(key)) continue;
                rval.addAll(this.ifFails(entry.getValue(), subject.get(key)).transform((Function)new Function<ValidationException, ValidationException>(){

                    public ValidationException apply(ValidationException exc) {
                        return exc.prepend(key);
                    }
                }).asSet());
            }
            return rval;
        }
        return Collections.emptyList();
    }

    private ImmutableList<ValidationException> testPropertyDependencies(final JSONObject subject) {
        return FluentIterable.from(this.propertyDependencies.keySet()).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return subject.has(input);
            }
        }).transformAndConcat((Function)new Function<String, Set<String>>(){

            public Set<String> apply(String input) {
                return (Set)ObjectSchema.this.propertyDependencies.get(input);
            }
        }).filter((Predicate)new Predicate<String>(){

            public boolean apply(String mustBePresent) {
                return !subject.has(mustBePresent);
            }
        }).transform((Function)new Function<String, ValidationException>(){

            public ValidationException apply(String missingKey) {
                return new ValidationException((Schema)ObjectSchema.this, String.format("property [%s] is required", missingKey), "dependencies");
            }
        }).toList();
    }

    private List<ValidationException> testRequiredProperties(final JSONObject subject) {
        return FluentIterable.from(this.requiredProperties).filter((Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !subject.has(key);
            }
        }).transform((Function)new Function<String, ValidationException>(){

            public ValidationException apply(String missingKey) {
                return new ValidationException((Schema)ObjectSchema.this, String.format("required key [%s] not found", missingKey), "required");
            }
        }).toList();
    }

    private List<ValidationException> testSchemaDependencies(JSONObject subject) {
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        for (Map.Entry<String, Schema> schemaDep : this.schemaDependencies.entrySet()) {
            String propName = schemaDep.getKey();
            if (!subject.has(propName)) continue;
            rval.addAll(this.ifFails(schemaDep.getValue(), subject).asSet());
        }
        return rval;
    }

    private List<ValidationException> testSize(JSONObject subject) {
        int actualSize = subject.length();
        if (this.minProperties != null && actualSize < this.minProperties) {
            return Arrays.asList(new ValidationException((Schema)this, String.format("minimum size: [%d], found: [%d]", this.minProperties, actualSize), "minProperties"));
        }
        if (this.maxProperties != null && actualSize > this.maxProperties) {
            return Arrays.asList(new ValidationException((Schema)this, String.format("maximum size: [%d], found: [%d]", this.maxProperties, actualSize), "maxProperties"));
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONObject)) {
            if (this.requiresObject) {
                throw new ValidationException((Schema)this, JSONObject.class, subject);
            }
        } else {
            ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
            JSONObject objSubject = (JSONObject)subject;
            failures.addAll(this.testProperties(objSubject));
            failures.addAll(this.testRequiredProperties(objSubject));
            failures.addAll((Collection<ValidationException>)this.testAdditionalProperties(objSubject));
            failures.addAll(this.testSize(objSubject));
            failures.addAll((Collection<ValidationException>)this.testPropertyDependencies(objSubject));
            failures.addAll(this.testSchemaDependencies(objSubject));
            failures.addAll(this.testPatternProperties(objSubject));
            ValidationException.throwFor(this, failures);
        }
    }

    @Override
    public boolean definesProperty(String field) {
        String remaining;
        String nextToken;
        int firstSlashIdx = (field = field.replaceFirst("^#", "").replaceFirst("^/", "")).indexOf(47);
        if (firstSlashIdx == -1) {
            nextToken = field;
            remaining = null;
        } else {
            nextToken = field.substring(0, firstSlashIdx);
            remaining = field.substring(firstSlashIdx + 1);
        }
        return !field.isEmpty() && (this.definesSchemaProperty(nextToken, remaining) || this.definesPatternProperty(nextToken, remaining) || this.definesSchemaDependencyProperty(field));
    }

    private boolean definesSchemaProperty(String current, String remaining) {
        boolean hasSuffix;
        current = this.unescape(current);
        boolean bl = hasSuffix = remaining != null;
        if (this.propertySchemas.containsKey(current)) {
            if (hasSuffix) {
                return this.propertySchemas.get(current).definesProperty(remaining);
            }
            return true;
        }
        return false;
    }

    private boolean definesPatternProperty(final String current, final String remaining) {
        return FluentIterable.from(this.patternProperties.keySet()).filter((Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern pattern) {
                return pattern.matcher(current).matches();
            }
        }).transform((Function)new Function<Pattern, Schema>(){

            public Schema apply(Pattern pattern) {
                return (Schema)ObjectSchema.this.patternProperties.get(pattern);
            }
        }).firstMatch((Predicate)new Predicate<Schema>(){

            public boolean apply(Schema schema) {
                return remaining == null || schema.definesProperty(remaining);
            }
        }).isPresent();
    }

    private boolean definesSchemaDependencyProperty(final String field) {
        return this.schemaDependencies.containsKey(field) || FluentIterable.from(this.schemaDependencies.values()).firstMatch((Predicate)new Predicate<Schema>(){

            public boolean apply(Schema schema) {
                return schema.definesProperty(field);
            }
        }).isPresent();
    }

    private String unescape(String value) {
        return value.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)o;
            return that.canEqual(this) && this.additionalProperties == that.additionalProperties && this.requiresObject == that.requiresObject && Objects.equals(this.propertySchemas, that.propertySchemas) && Objects.equals(this.schemaOfAdditionalProperties, that.schemaOfAdditionalProperties) && Objects.equals(this.requiredProperties, that.requiredProperties) && Objects.equals(this.minProperties, that.minProperties) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.propertyDependencies, that.propertyDependencies) && Objects.equals(this.schemaDependencies, that.schemaDependencies) && Objects.equals(this.patternProperties, that.patternProperties) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertySchemas, this.additionalProperties, this.schemaOfAdditionalProperties, this.requiredProperties, this.minProperties, this.maxProperties, this.propertyDependencies, this.schemaDependencies, this.requiresObject, this.patternProperties);
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresObject) {
            writer.key("type").value("object");
        }
        if (!this.propertySchemas.isEmpty()) {
            writer.key("properties");
            writer.printSchemaMap(this.propertySchemas);
        }
        writer.ifPresent("minProperties", this.minProperties);
        writer.ifPresent("maxProperties", this.maxProperties);
        if (!this.requiredProperties.isEmpty()) {
            writer.key("required").value(this.requiredProperties);
        }
        if (this.schemaOfAdditionalProperties != null) {
            writer.key("additionalProperties");
            this.schemaOfAdditionalProperties.describeTo(writer);
        }
        if (!this.propertyDependencies.isEmpty()) {
            this.describePropertyDependenciesTo(writer);
        }
        if (!this.schemaDependencies.isEmpty()) {
            writer.key("dependencies");
            writer.printSchemaMap(this.schemaDependencies);
        }
        if (!this.patternProperties.isEmpty()) {
            writer.key("patternProperties");
            writer.printSchemaMap(this.patternProperties);
        }
        writer.ifFalse("additionalProperties", this.additionalProperties);
    }

    private void describePropertyDependenciesTo(JSONPrinter writer) {
        writer.key("dependencies");
        writer.object();
        for (Map.Entry<String, Set<String>> entry : this.propertyDependencies.entrySet()) {
            writer.key(entry.getKey());
            writer.array();
            for (String value : entry.getValue()) {
                writer.value(value);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectSchema;
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private final Map<Pattern, Schema> patternProperties = new HashMap<Pattern, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new LinkedHashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull(propName, "propName cannot be null");
            Objects.requireNonNull(schema, "schema cannot be null");
            this.propertySchemas.put(propName, schema);
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder patternProperty(Pattern pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder patternProperty(String pattern, Schema schema) {
            return this.patternProperty(Pattern.compile(pattern), schema);
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new LinkedHashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }
    }
}

