/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;

public class CombinedSchema
extends Schema {
    public static final ValidationCriterion ALL_CRITERION = new ValidationCriterion(){

        @Override
        public void validate(int subschemaCount, int matchingCount) {
            if (matchingCount < subschemaCount) {
                throw new ValidationException(null, String.format("only %d subschema matches out of %d", matchingCount, subschemaCount), "allOf");
            }
        }

        public String toString() {
            return "allOf";
        }
    };
    public static final ValidationCriterion ANY_CRITERION = new ValidationCriterion(){

        @Override
        public void validate(int subschemaCount, int matchingCount) {
            if (matchingCount == 0) {
                throw new ValidationException(null, String.format("no subschema matched out of the total %d subschemas", subschemaCount), "anyOf");
            }
        }

        public String toString() {
            return "anyOf";
        }
    };
    public static final ValidationCriterion ONE_CRITERION = new ValidationCriterion(){

        @Override
        public void validate(int subschemaCount, int matchingCount) {
            if (matchingCount != 1) {
                throw new ValidationException(null, String.format("%d subschemas matched instead of one", matchingCount), "oneOf");
            }
        }

        public String toString() {
            return "oneOf";
        }
    };
    private final Collection<Schema> subschemas;
    private final ValidationCriterion criterion;

    public static Builder allOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ALL_CRITERION);
    }

    public static Builder anyOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ANY_CRITERION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Collection<Schema> subschemas) {
        return new Builder().subschemas(subschemas);
    }

    public static Builder oneOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ONE_CRITERION);
    }

    public CombinedSchema(Builder builder) {
        super(builder);
        this.criterion = Objects.requireNonNull(builder.criterion, "criterion cannot be null");
        this.subschemas = Objects.requireNonNull(builder.subschemas, "subschemas cannot be null");
    }

    public ValidationCriterion getCriterion() {
        return this.criterion;
    }

    public Collection<Schema> getSubschemas() {
        return this.subschemas;
    }

    private ValidationException getFailure(Schema schema, Object subject) {
        try {
            schema.validate(subject);
            return null;
        }
        catch (ValidationException e) {
            return e;
        }
    }

    @Override
    public void validate(final Object subject) {
        ImmutableList failures = FluentIterable.from(this.subschemas).transform((Function)new Function<Schema, ValidationException>(){

            public ValidationException apply(Schema schema) {
                return CombinedSchema.this.getFailure(schema, subject);
            }
        }).filter(Predicates.notNull()).toList();
        int matchingCount = this.subschemas.size() - failures.size();
        try {
            this.criterion.validate(this.subschemas.size(), matchingCount);
        }
        catch (ValidationException e) {
            throw new ValidationException(this, new StringBuilder(e.getPointerToViolation()), e.getMessage(), (List<ValidationException>)failures, e.getKeyword());
        }
    }

    @Override
    public boolean definesProperty(final String field) {
        int matching = FluentIterable.from(this.subschemas).filter((Predicate)new Predicate<Schema>(){

            public boolean apply(Schema schema) {
                return schema.definesProperty(field);
            }
        }).size();
        try {
            this.criterion.validate(this.subschemas.size(), matching);
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CombinedSchema) {
            CombinedSchema that = (CombinedSchema)o;
            return that.canEqual(this) && Objects.equals(this.subschemas, that.subschemas) && Objects.equals(this.criterion, that.criterion) && super.equals(that);
        }
        return false;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key(this.criterion.toString());
        writer.array();
        for (Schema subschema : this.subschemas) {
            subschema.describeTo(writer);
        }
        writer.endArray();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subschemas, this.criterion);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CombinedSchema;
    }

    public static interface ValidationCriterion {
        public void validate(int var1, int var2);
    }

    public static class Builder
    extends Schema.Builder<CombinedSchema> {
        private ValidationCriterion criterion;
        private Collection<Schema> subschemas = new ArrayList<Schema>();

        @Override
        public CombinedSchema build() {
            return new CombinedSchema(this);
        }

        public Builder criterion(ValidationCriterion criterion) {
            this.criterion = criterion;
            return this;
        }

        public Builder subschema(Schema subschema) {
            this.subschemas.add(subschema);
            return this;
        }

        public Builder subschemas(Collection<Schema> subschemas) {
            this.subschemas = subschemas;
            return this;
        }
    }
}

