/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.base.HasAlternateSize;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.ResponsiveHelper;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasConstrainedValue;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SimpleKeyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueListBox<T>
extends Composite
implements HasConstrainedValue<T>,
IsEditor<TakesValueEditor<T>>,
HasName,
HasId,
HasEnabled,
HasSize,
HasAlternateSize,
IsSearchQuery,
IsResponsive,
HasStyle {
    private final Map<Object, Integer> valueKeyToIndex = new HashMap<Object, Integer>();
    private final List<T> valueList = new ArrayList<T>();
    private final Renderer<T> renderer;
    private final ProvidesKey<T> keyProvider;
    private TakesValueEditor<T> editor;
    private T value;

    public ValueListBox(Renderer<T> renderer) {
        this(renderer, (ProvidesKey<T>)new SimpleKeyProvider());
    }

    public ValueListBox(Renderer<T> renderer, ProvidesKey<T> keyProvider) {
        this.keyProvider = keyProvider;
        this.renderer = renderer;
        this.initWidget((Widget)new ListBox());
        this.getListBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = ValueListBox.this.getListBox().getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                Object newValue = ValueListBox.this.valueList.get(selectedIndex);
                ValueListBox.this.setValue(newValue, true);
            }
        });
    }

    public void setName(String name) {
        this.getListBox().setName(name);
    }

    public String getName() {
        return this.getListBox().getName();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public TakesValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public T getValue() {
        return this.value;
    }

    public void setAcceptableValues(Collection<T> newValues) {
        this.valueList.clear();
        this.valueKeyToIndex.clear();
        ListBox listBox = this.getListBox();
        listBox.clear();
        for (T nextNewValue : newValues) {
            this.addValue(nextNewValue);
        }
        this.updateListBox();
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean fireEvents) {
        if (value == this.value || this.value != null && this.value.equals(value)) {
            return;
        }
        T before = this.value;
        this.value = value;
        this.updateListBox();
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, before, value);
        }
    }

    private void addValue(T value) {
        Object key = this.keyProvider.getKey(value);
        if (this.valueKeyToIndex.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate value: " + value);
        }
        this.valueKeyToIndex.put(key, this.valueList.size());
        this.valueList.add(value);
        this.getListBox().addItem(this.renderer.render(value));
        assert (this.valueList.size() == this.getListBox().getItemCount());
    }

    private ListBox getListBox() {
        return (ListBox)this.getWidget();
    }

    private void updateListBox() {
        Object key = this.keyProvider.getKey(this.value);
        Integer index = this.valueKeyToIndex.get(key);
        if (index == null) {
            this.addValue(this.value);
        }
        index = this.valueKeyToIndex.get(key);
        this.getListBox().setSelectedIndex(index);
    }

    @Override
    public String getId() {
        return this.getListBox().getId();
    }

    @Override
    public void setId(String id) {
        this.getListBox().setId(id);
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery((Widget)this, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery((Widget)this);
    }

    @Override
    public void setAlternateSize(AlternateSize size) {
        StyleHelper.changeStyle((UIObject)this, size, AlternateSize.class);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    public void setEnabled(boolean enabled) {
        this.getListBox().setEnabled(enabled);
        if (enabled) {
            this.removeStyleName("disabled");
        } else {
            this.addStyleName("disabled");
        }
    }

    public boolean isEnabled() {
        return this.getListBox().isEnabled();
    }

    @Override
    public void setShowOn(Device device) {
        ResponsiveHelper.setShowOn(this, device);
    }

    @Override
    public void setHideOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setStyle(Style style) {
        StyleHelper.setStyle(this, style);
    }

    @Override
    public void addStyle(Style style) {
        StyleHelper.addStyle(this, style);
    }

    @Override
    public void removeStyle(Style style) {
        StyleHelper.removeStyle(this, style);
    }
}

