/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.base.HasPlacement;
import com.github.gwtbootstrap.client.ui.base.HasShowDelay;
import com.github.gwtbootstrap.client.ui.base.HasTrigger;
import com.github.gwtbootstrap.client.ui.base.IsAnimated;
import com.github.gwtbootstrap.client.ui.constants.Placement;
import com.github.gwtbootstrap.client.ui.constants.Trigger;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HasText;
import java.util.Set;

public class TooltipCellDecorator<C>
implements Cell<C>,
IsAnimated,
HasTrigger,
HasPlacement,
HasText,
HasShowDelay {
    protected boolean animated = true;
    protected Placement placement = Placement.TOP;
    protected Trigger trigger = Trigger.HOVER;
    protected int showDelayInMilliseconds = 0;
    protected int hideDelayInMilliseconds = 0;
    protected String container;
    private static Template template = (Template)GWT.create(Template.class);
    private final Cell<C> cell;
    private String tooltip;

    public TooltipCellDecorator(Cell<C> cell) {
        this.cell = cell;
    }

    public boolean dependsOnSelection() {
        return this.cell.dependsOnSelection();
    }

    public Set<String> getConsumedEvents() {
        return this.cell.getConsumedEvents();
    }

    public boolean handlesSelection() {
        return this.cell.handlesSelection();
    }

    public boolean isEditing(Cell.Context context, Element parent, C value) {
        return this.cell.isEditing(context, this.getCellParent(parent), value);
    }

    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        this.cell.onBrowserEvent(context, this.getCellParent(parent), value, event, valueUpdater);
    }

    public void render(final Cell.Context context, final C value, SafeHtmlBuilder sb) {
        SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
        this.cell.render(context, value, cellBuilder);
        final String id = DOM.createUniqueId();
        sb.append(template.span(id, cellBuilder.toSafeHtml()));
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Tooltip.configure("#" + id + "> :first-child", TooltipCellDecorator.this.getTooltipText(context, value), TooltipCellDecorator.this.getAnimation(context, value), TooltipCellDecorator.this.getPlacement(context, value).get(), TooltipCellDecorator.this.getTrigger(context, value).get(), TooltipCellDecorator.this.getShowDelay(context, value), TooltipCellDecorator.this.getHideDelay(context, value), TooltipCellDecorator.this.getContainer());
            }
        });
    }

    public boolean resetFocus(Cell.Context context, Element parent, C value) {
        return this.cell.resetFocus(context, this.getCellParent(parent), value);
    }

    public void setValue(Cell.Context context, Element parent, C value) {
        this.cell.setValue(context, this.getCellParent(parent), value);
    }

    @Override
    public void setAnimation(boolean animated) {
        this.animated = animated;
    }

    @Override
    public boolean getAnimation() {
        return this.animated;
    }

    protected boolean getAnimation(Cell.Context context, C value) {
        return this.getAnimation();
    }

    @Override
    public void setPlacement(Placement placement) {
        assert (placement != null) : "should not be null";
        this.placement = placement;
    }

    @Override
    public Placement getPlacement() {
        return this.placement;
    }

    protected Placement getPlacement(Cell.Context context, C value) {
        return this.getPlacement();
    }

    @Override
    public void setTrigger(Trigger trigger) {
        assert (trigger != null) : "should not be null";
        this.trigger = trigger;
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }

    protected Trigger getTrigger(Cell.Context context, C value) {
        return this.getTrigger();
    }

    @Override
    public void setShowDelay(int delayInMilliseconds) {
        this.showDelayInMilliseconds = delayInMilliseconds;
    }

    @Override
    public int getShowDelay() {
        return this.showDelayInMilliseconds;
    }

    protected int getShowDelay(Cell.Context context, C value) {
        return this.getShowDelay();
    }

    @Override
    public void setHideDelay(int delayInMilliseconds) {
        this.hideDelayInMilliseconds = delayInMilliseconds;
    }

    @Override
    public int getHideDelay() {
        return this.hideDelayInMilliseconds;
    }

    protected int getHideDelay(Cell.Context context, C value) {
        return this.getHideDelay();
    }

    public String getText() {
        return this.tooltip;
    }

    public void setText(String text) {
        assert (text != null) : "should not be null";
        this.tooltip = text;
    }

    protected String getTooltipText(Cell.Context context, C value) {
        return this.getText();
    }

    private Element getCellParent(Element parent) {
        return (Element)parent.getFirstChildElement().cast();
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<span class='gb-tooltip-cell' id='{0}'>{1}</span>")
        public SafeHtml span(String var1, SafeHtml var2);
    }
}

