/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.base.DropdownBase;
import com.github.gwtbootstrap.client.ui.base.HasType;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.BaseIconType;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.Widget;

public class SplitDropdownButton
extends DropdownBase
implements HasClickHandlers,
HasType<ButtonType> {
    private Button button;
    private Button trigger;

    public SplitDropdownButton() {
        super("div");
        this.addStyleName("btn-group");
    }

    public SplitDropdownButton(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        this.button.setText(text);
    }

    @Override
    public String getText() {
        return this.button.getText();
    }

    @Override
    protected IconAnchor createTrigger() {
        this.button = new Button();
        this.addWidget((Widget)this.button);
        this.trigger = new Button();
        this.trigger.setCaret(true);
        return this.trigger;
    }

    public void setSize(ButtonSize size) {
        this.trigger.setSize(size);
        this.button.setSize(size);
    }

    @Override
    public void setType(ButtonType type) {
        this.trigger.setType(type);
        this.button.setType(type);
    }

    @Override
    public void setIcon(IconType type) {
        this.setBaseIcon(type);
    }

    @Override
    public void setBaseIcon(BaseIconType type) {
        this.button.setBaseIcon(type);
    }

    @Override
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.button.addClickHandler(handler);
    }

    @Override
    public void setIconSize(IconSize size) {
        this.button.setIconSize(size);
    }

    @Override
    @UiChild(tagname="customTrigger", limit=1)
    public void addCustomTrigger(Widget w) {
        this.button.insert(w, 0);
    }

    @Override
    public void setCustomIconStyle(String customIconStyle) {
        this.button.setCustomIconStyle(customIconStyle);
    }

    @Override
    public void setIconPosition(IconPosition position) {
        this.button.setIconPosition(position);
    }
}

