/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.AbstractTypography;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.HasText;

public class Heading
extends ComplexWidget
implements HasText {
    private static final int HEADER_MINIMUM = 1;
    private static final int HEADER_MAXIMUM = 6;
    private Small small = new Small();
    private String text;

    @UiConstructor
    public Heading(int size) {
        super("h" + size);
        if (size < 1 || size > 6) {
            throw new IllegalArgumentException("The size of the header must be between 1 and 6.");
        }
        super.add(this.small);
    }

    public Heading(int size, String text) {
        this(size);
        this.setText(text);
    }

    public Heading(int size, String text, String subtext) {
        this(size, text);
        this.setSubtext(subtext);
    }

    public void setSubtext(String subtext) {
        this.small.setText(subtext);
        this.redraw();
    }

    private void redraw() {
        this.setText(this.text);
    }

    public void setText(String text) {
        this.text = text;
        this.getElement().setInnerHTML(text + " " + this.small.toString());
    }

    public String getText() {
        return this.text;
    }

    private class Small
    extends AbstractTypography {
        public Small() {
            super("small");
        }
    }
}

