/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.HasAlternateSize;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.ui.client.adapters.HasTextEditor;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class FileUpload
extends com.google.gwt.user.client.ui.FileUpload
implements HasSize,
HasAlternateSize,
IsSearchQuery,
HasId,
HasText,
IsEditor<HasTextEditor>,
HasEditorErrors<String> {
    private Widget controlGroup;
    private Widget errorLabel;

    public FileUpload() {
        this.setStyleName("");
    }

    public void showErrors(List<EditorError> errors) {
        FileUpload decoratedWidget;
        FileUpload fileUpload = decoratedWidget = this.controlGroup != null ? this.controlGroup : this;
        if (errors != null && !errors.isEmpty()) {
            StyleHelper.addStyle(decoratedWidget, ControlGroupType.ERROR);
            SafeHtmlBuilder sb = new SafeHtmlBuilder();
            for (EditorError error : errors) {
                if (error.getEditor() != this) continue;
                error.setConsumed(true);
                sb.appendEscaped(error.getMessage());
                sb.appendHtmlConstant("<br />");
            }
            this.setErrorLabelText(sb.toSafeHtml().asString());
        } else {
            StyleHelper.removeStyle(decoratedWidget, ControlGroupType.ERROR);
            this.setErrorLabelText("");
        }
    }

    public void setControlGroup(Widget controlGroup) {
        this.controlGroup = controlGroup;
    }

    public void setErrorLabel(Widget errorLabel) {
        this.errorLabel = errorLabel;
    }

    protected void setErrorLabelText(String errorMessage) {
        if (this.errorLabel != null) {
            this.errorLabel.getElement().setInnerHTML(errorMessage);
        }
    }

    public HasTextEditor asEditor() {
        return HasTextEditor.of((HasText)this);
    }

    public String getText() {
        String filename = this.getFilename();
        return filename != null && !"".equals(filename.trim()) ? filename : null;
    }

    public void setText(String value) {
        try {
            this.getElement().setAttribute("value", value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setAlternateSize(AlternateSize size) {
        StyleHelper.changeStyle((UIObject)this, size, AlternateSize.class);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery((Widget)this, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery((Widget)this);
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    @Override
    public void setId(String id) {
        this.getElement().setId(id);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.removeStyleName("disabled");
        } else {
            this.addStyleName("disabled");
        }
    }
}

