/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Collapse;
import com.github.gwtbootstrap.client.ui.base.MarkupWidget;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.ui.Widget;

public class CollapseTrigger
extends MarkupWidget {
    private String target;
    private String parent;
    private boolean isAccordionTrigger = false;

    public CollapseTrigger(String target) {
        this.target = target;
    }

    public CollapseTrigger() {
    }

    @Override
    public Widget asWidget() {
        if (this.widget != null) {
            Element element = this.widget.getElement();
            if (this.isAccordionTrigger) {
                element.setAttribute("data-toggle", "collapse");
                element.removeAttribute("data-target");
                element.setAttribute("href", this.target);
                if (this.parent != null && !this.parent.isEmpty()) {
                    this.setParent(this.parent);
                }
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Collapse.configure(CollapseTrigger.this.target, CollapseTrigger.this.parent, false);
                    }
                });
                return super.asWidget();
            }
            if (element.hasAttribute("data-toggle") && this.widget instanceof HasClickHandlers && !this.widget.isAttached()) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Collapse.configure(CollapseTrigger.this.target, CollapseTrigger.this.parent, false);
                        ((HasClickHandlers)CollapseTrigger.this.widget).addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                Collapse.changeVisibility(CollapseTrigger.this.target, "toggle");
                            }
                        });
                    }
                });
                return super.asWidget();
            }
            element.setAttribute("data-target", this.target);
            element.setAttribute("data-toggle", "collapse");
            if (this.parent != null && !this.parent.isEmpty()) {
                this.setParent(this.parent);
            }
        }
        return super.asWidget();
    }

    public void setTarget(String target) {
        this.target = target;
        if (this.widget != null) {
            Element element = this.widget.getElement();
            element.setAttribute("data-target", target);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setParent(String parent) {
        this.parent = parent;
        if (this.widget != null) {
            this.widget.getElement().setAttribute("data-parent", parent);
        }
    }

    protected boolean isAccordionTrigger() {
        return this.isAccordionTrigger;
    }

    protected void setAccordionTrigger(boolean accordionTrigger) {
        this.isAccordionTrigger = accordionTrigger;
    }
}

