/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BaseJvmBuffer;
import com.ditchoom.buffer.BaseJvmBufferKt;
import com.ditchoom.buffer.MutableNativeData;
import com.ditchoom.buffer.NativeData;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.ReadBufferKt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"toNativeData", "Lcom/ditchoom/buffer/NativeData;", "Lcom/ditchoom/buffer/ReadBuffer;", "toByteArray", "", "toMutableNativeData", "Lcom/ditchoom/buffer/MutableNativeData;", "Lcom/ditchoom/buffer/PlatformBuffer;", "buffer_release"})
public final class NativeDataConversions_jvmCommonKt {
    @NotNull
    public static final NativeData toNativeData(@NotNull ReadBuffer $this$toNativeData) {
        Intrinsics.checkNotNullParameter((Object)$this$toNativeData, (String)"<this>");
        ReadBuffer unwrapped = ReadBufferKt.unwrapFully($this$toNativeData);
        if (unwrapped != $this$toNativeData) {
            return NativeDataConversions_jvmCommonKt.toNativeData(unwrapped);
        }
        if ($this$toNativeData instanceof BaseJvmBuffer && ((BaseJvmBuffer)$this$toNativeData).getByteBuffer().isDirect()) {
            ByteBuffer duplicate = ((BaseJvmBuffer)$this$toNativeData).getByteBuffer().duplicate();
            duplicate.position(((BaseJvmBuffer)$this$toNativeData).position());
            duplicate.limit(((BaseJvmBuffer)$this$toNativeData).limit());
            ByteBuffer byteBuffer = duplicate.asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
            return new NativeData(byteBuffer);
        }
        byte[] bytes = NativeDataConversions_jvmCommonKt.toByteArray($this$toNativeData);
        ByteBuffer direct = ByteBuffer.allocateDirect(bytes.length);
        direct.put(bytes);
        direct.flip();
        ByteBuffer byteBuffer = direct.asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        return new NativeData(byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull ReadBuffer $this$toByteArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        ReadBuffer unwrapped = ReadBufferKt.unwrapFully($this$toByteArray);
        if (unwrapped != $this$toByteArray) {
            return NativeDataConversions_jvmCommonKt.toByteArray(unwrapped);
        }
        if ($this$toByteArray instanceof BaseJvmBuffer) {
            if (((BaseJvmBuffer)$this$toByteArray).getByteBuffer().hasArray()) {
                byte[] array = ((BaseJvmBuffer)$this$toByteArray).getByteBuffer().array();
                int offset = ((BaseJvmBuffer)$this$toByteArray).getByteBuffer().arrayOffset();
                int pos = ((BaseJvmBuffer)$this$toByteArray).position();
                int rem = $this$toByteArray.remaining();
                if (offset == 0 && pos == 0 && rem == array.length) {
                    byte[] byArray2 = array;
                    Intrinsics.checkNotNull((Object)byArray2);
                    byArray = byArray2;
                } else {
                    byte[] result = new byte[rem];
                    System.arraycopy(array, offset + pos, result, 0, rem);
                    byArray = result;
                }
            } else {
                int pos = ((BaseJvmBuffer)$this$toByteArray).position();
                byte[] result = BaseJvmBufferKt.toArray(((BaseJvmBuffer)$this$toByteArray).getByteBuffer(), $this$toByteArray.remaining());
                ByteBuffer byteBuffer = ((BaseJvmBuffer)$this$toByteArray).getByteBuffer();
                Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)byteBuffer).position(pos);
                byArray = result;
            }
        } else {
            void var3_7;
            int pos = $this$toByteArray.position();
            byte[] result = $this$toByteArray.readByteArray($this$toByteArray.remaining());
            $this$toByteArray.position(pos);
            byArray = var3_7;
        }
        return byArray;
    }

    @NotNull
    public static final MutableNativeData toMutableNativeData(@NotNull PlatformBuffer $this$toMutableNativeData) {
        Intrinsics.checkNotNullParameter((Object)$this$toMutableNativeData, (String)"<this>");
        PlatformBuffer unwrapped = $this$toMutableNativeData.unwrap();
        if (unwrapped != $this$toMutableNativeData) {
            return NativeDataConversions_jvmCommonKt.toMutableNativeData(unwrapped);
        }
        if ($this$toMutableNativeData instanceof BaseJvmBuffer && ((BaseJvmBuffer)$this$toMutableNativeData).getByteBuffer().isDirect()) {
            ByteBuffer duplicate = ((BaseJvmBuffer)$this$toMutableNativeData).getByteBuffer().duplicate();
            duplicate.position(((BaseJvmBuffer)$this$toMutableNativeData).position());
            duplicate.limit(((BaseJvmBuffer)$this$toMutableNativeData).limit());
            Intrinsics.checkNotNull((Object)duplicate);
            return new MutableNativeData(duplicate);
        }
        byte[] bytes = NativeDataConversions_jvmCommonKt.toByteArray($this$toMutableNativeData);
        ByteBuffer direct = ByteBuffer.allocateDirect(bytes.length);
        direct.put(bytes);
        direct.flip();
        Intrinsics.checkNotNull((Object)direct);
        return new MutableNativeData(direct);
    }
}

