/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.SharedMemory;
import com.ditchoom.buffer.AllocationZone;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.DirectJvmBuffer;
import com.ditchoom.buffer.HeapJvmBuffer;
import com.ditchoom.buffer.JvmBuffer;
import com.ditchoom.buffer.ParcelableSharedMemoryBuffer;
import com.ditchoom.buffer.PlatformBuffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"allocate", "Lcom/ditchoom/buffer/PlatformBuffer;", "Lcom/ditchoom/buffer/PlatformBuffer$Companion;", "size", "", "zone", "Lcom/ditchoom/buffer/AllocationZone;", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "wrap", "array", "", "allocateNative", "allocateShared", "buffer_release"})
@JvmName(name="BufferFactoryAndroid")
public final class BufferFactoryAndroid {
    @SuppressLint(value={"NewApi"})
    @NotNull
    public static final PlatformBuffer allocate(@NotNull PlatformBuffer.Companion $this$allocate, int size, @NotNull AllocationZone zone, @NotNull ByteOrder byteOrder) {
        PlatformBuffer platformBuffer;
        java.nio.ByteOrder byteOrder2;
        Intrinsics.checkNotNullParameter((Object)$this$allocate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[byteOrder.ordinal()]) {
            case 1: {
                byteOrder2 = java.nio.ByteOrder.BIG_ENDIAN;
                break;
            }
            case 2: {
                byteOrder2 = java.nio.ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.nio.ByteOrder byteOrderNative = byteOrder2;
        AllocationZone allocationZone = zone;
        if (Intrinsics.areEqual((Object)allocationZone, (Object)AllocationZone.Heap.INSTANCE)) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(size).order(byteOrderNative);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
            platformBuffer = new HeapJvmBuffer(byteBuffer);
        } else if (Intrinsics.areEqual((Object)allocationZone, (Object)AllocationZone.Direct.INSTANCE)) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size).order(byteOrderNative);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
            platformBuffer = new DirectJvmBuffer(byteBuffer);
        } else if (Intrinsics.areEqual((Object)allocationZone, (Object)AllocationZone.SharedMemory.INSTANCE)) {
            JvmBuffer jvmBuffer;
            if (Build.VERSION.SDK_INT >= 27 && size > 0) {
                SharedMemory sharedMemory = SharedMemory.create(null, (int)size);
                Intrinsics.checkNotNullExpressionValue((Object)sharedMemory, (String)"create(...)");
                SharedMemory sharedMemory2 = sharedMemory;
                ByteBuffer buffer = sharedMemory2.mapReadWrite().order(byteOrderNative);
                Intrinsics.checkNotNull((Object)buffer);
                jvmBuffer = new ParcelableSharedMemoryBuffer(buffer, sharedMemory2);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size).order(byteOrderNative);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
                jvmBuffer = new DirectJvmBuffer(byteBuffer);
            }
            platformBuffer = jvmBuffer;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return platformBuffer;
    }

    public static /* synthetic */ PlatformBuffer allocate$default(PlatformBuffer.Companion companion, int n, AllocationZone allocationZone, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            allocationZone = AllocationZone.Heap.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return BufferFactoryAndroid.allocate(companion, n, allocationZone, byteOrder);
    }

    @NotNull
    public static final PlatformBuffer wrap(@NotNull PlatformBuffer.Companion $this$wrap, @NotNull byte[] array, @NotNull ByteOrder byteOrder) {
        java.nio.ByteOrder byteOrder2;
        Intrinsics.checkNotNullParameter((Object)$this$wrap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[byteOrder.ordinal()]) {
            case 1: {
                byteOrder2 = java.nio.ByteOrder.BIG_ENDIAN;
                break;
            }
            case 2: {
                byteOrder2 = java.nio.ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.nio.ByteOrder byteOrderNative = byteOrder2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(array).order(byteOrderNative);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
        return new HeapJvmBuffer(byteBuffer);
    }

    public static /* synthetic */ PlatformBuffer wrap$default(PlatformBuffer.Companion companion, byte[] byArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 2) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return BufferFactoryAndroid.wrap(companion, byArray, byteOrder);
    }

    @NotNull
    public static final PlatformBuffer allocateNative(@NotNull PlatformBuffer.Companion $this$allocateNative, int size, @NotNull ByteOrder byteOrder) {
        java.nio.ByteOrder byteOrder2;
        Intrinsics.checkNotNullParameter((Object)$this$allocateNative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[byteOrder.ordinal()]) {
            case 1: {
                byteOrder2 = java.nio.ByteOrder.BIG_ENDIAN;
                break;
            }
            case 2: {
                byteOrder2 = java.nio.ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.nio.ByteOrder byteOrderNative = byteOrder2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size).order(byteOrderNative);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
        return new DirectJvmBuffer(byteBuffer);
    }

    public static /* synthetic */ PlatformBuffer allocateNative$default(PlatformBuffer.Companion companion, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return BufferFactoryAndroid.allocateNative(companion, n, byteOrder);
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public static final PlatformBuffer allocateShared(@NotNull PlatformBuffer.Companion $this$allocateShared, int size, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)$this$allocateShared, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        return BufferFactoryAndroid.allocate($this$allocateShared, size, AllocationZone.SharedMemory.INSTANCE, byteOrder);
    }

    public static /* synthetic */ PlatformBuffer allocateShared$default(PlatformBuffer.Companion companion, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return BufferFactoryAndroid.allocateShared(companion, n, byteOrder);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ByteOrder.values().length];
            try {
                nArray[ByteOrder.BIG_ENDIAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ByteOrder.LITTLE_ENDIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

