/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BufferScope;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.CharsetEncoderHelperKt;
import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.ReadBufferKt;
import com.ditchoom.buffer.ScopedBuffer;
import com.ditchoom.buffer.UnsafeMemory;
import com.ditchoom.buffer.WriteBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\u0011\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0007H\u0096\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\"H\u0016J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020$H\u0016J\u0010\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0005H\u0016J\u0019\u00105\u001a\u00020-2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\"H\u0096\u0002J\u0019\u00105\u001a\u00020-2\u0006\u0010(\u001a\u00020\u00072\u0006\u00100\u001a\u00020$H\u0096\u0002J\u0019\u00105\u001a\u00020-2\u0006\u0010(\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0096\u0002J\u0019\u00105\u001a\u00020-2\u0006\u0010(\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0005H\u0096\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0007H\u0016J \u00109\u001a\u00020-2\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020?2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020?2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020D2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010E\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020D2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J \u0010I\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020H2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016J\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020LH\u0016J\n\u0010Q\u001a\u0004\u0018\u00010OH\u0002J\u0018\u0010R\u001a\u00020S2\u0006\u0010<\u001a\u00020\u00072\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020-2\u0006\u0010W\u001a\u00020X2\u0006\u0010T\u001a\u00020UH\u0016J\f\u0010Y\u001a\u00020Z*\u00020UH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/ditchoom/buffer/UnsafeScopedBuffer;", "Lcom/ditchoom/buffer/ScopedBuffer;", "scope", "Lcom/ditchoom/buffer/BufferScope;", "nativeAddress", "", "capacity", "", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "<init>", "(Lcom/ditchoom/buffer/BufferScope;JILcom/ditchoom/buffer/ByteOrder;)V", "getScope", "()Lcom/ditchoom/buffer/BufferScope;", "getNativeAddress", "()J", "getCapacity", "()I", "getByteOrder", "()Lcom/ditchoom/buffer/ByteOrder;", "positionValue", "limitValue", "nativeSize", "getNativeSize", "littleEndian", "", "position", "", "newPosition", "limit", "setLimit", "resetForRead", "resetForWrite", "readByte", "", "readShort", "", "readInt", "readLong", "get", "index", "getShort", "getInt", "getLong", "writeByte", "Lcom/ditchoom/buffer/WriteBuffer;", "byte", "writeShort", "short", "writeInt", "int", "writeLong", "long", "set", "readByteArray", "", "size", "writeBytes", "bytes", "offset", "length", "writeInts", "ints", "", "readInts", "dest", "writeShorts", "shorts", "", "readShorts", "writeLongs", "longs", "", "readLongs", "write", "buffer", "Lcom/ditchoom/buffer/ReadBuffer;", "slice", "byteBufferView", "Ljava/nio/ByteBuffer;", "byteBufferViewChecked", "getByteBufferView", "readString", "", "charset", "Lcom/ditchoom/buffer/Charset;", "writeString", "text", "", "toJavaCharset", "Ljava/nio/charset/Charset;", "buffer_release"})
public final class UnsafeScopedBuffer
implements ScopedBuffer {
    @NotNull
    private final BufferScope scope;
    private final long nativeAddress;
    private final int capacity;
    @NotNull
    private final ByteOrder byteOrder;
    private int positionValue;
    private int limitValue;
    private final boolean littleEndian;
    @Nullable
    private ByteBuffer byteBufferView;
    private boolean byteBufferViewChecked;

    public UnsafeScopedBuffer(@NotNull BufferScope scope, long nativeAddress, int capacity, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        this.scope = scope;
        this.nativeAddress = nativeAddress;
        this.capacity = capacity;
        this.byteOrder = byteOrder;
        this.limitValue = this.getCapacity();
        this.littleEndian = this.getByteOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    @NotNull
    public BufferScope getScope() {
        return this.scope;
    }

    @Override
    public long getNativeAddress() {
        return this.nativeAddress;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long getNativeSize() {
        return this.getCapacity();
    }

    @Override
    public int position() {
        return this.positionValue;
    }

    @Override
    public void position(int newPosition) {
        this.positionValue = newPosition;
    }

    @Override
    public int limit() {
        return this.limitValue;
    }

    @Override
    public void setLimit(int limit) {
        this.limitValue = limit;
    }

    @Override
    public void resetForRead() {
        this.limitValue = this.positionValue;
        this.positionValue = 0;
    }

    @Override
    public void resetForWrite() {
        this.positionValue = 0;
        this.limitValue = this.getCapacity();
    }

    @Override
    public byte readByte() {
        int n = this.positionValue;
        this.positionValue = n + 1;
        return UnsafeMemory.INSTANCE.getByte(this.getNativeAddress() + (long)n);
    }

    @Override
    public short readShort() {
        short result = this.getShort(this.positionValue);
        this.positionValue += 2;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.getInt(this.positionValue);
        this.positionValue += 4;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.getLong(this.positionValue);
        this.positionValue += 8;
        return result;
    }

    @Override
    public byte get(int index) {
        return UnsafeMemory.INSTANCE.getByte(this.getNativeAddress() + (long)index);
    }

    @Override
    public short getShort(int index) {
        short raw = UnsafeMemory.INSTANCE.getShort(this.getNativeAddress() + (long)index);
        return Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? raw : Short.reverseBytes(raw)) : (this.littleEndian ? Short.reverseBytes(raw) : raw);
    }

    @Override
    public int getInt(int index) {
        int raw = UnsafeMemory.INSTANCE.getInt(this.getNativeAddress() + (long)index);
        return Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? raw : Integer.reverseBytes(raw)) : (this.littleEndian ? Integer.reverseBytes(raw) : raw);
    }

    @Override
    public long getLong(int index) {
        long raw = UnsafeMemory.INSTANCE.getLong(this.getNativeAddress() + (long)index);
        return Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? raw : Long.reverseBytes(raw)) : (this.littleEndian ? Long.reverseBytes(raw) : raw);
    }

    @Override
    @NotNull
    public WriteBuffer writeByte(byte by) {
        int n = this.positionValue;
        this.positionValue = n + 1;
        UnsafeMemory.INSTANCE.putByte(this.getNativeAddress() + (long)n, by);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeShort(short s) {
        this.set(this.positionValue, s);
        this.positionValue += 2;
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeInt(int n) {
        this.set(this.positionValue, n);
        this.positionValue += 4;
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeLong(long l) {
        this.set(this.positionValue, l);
        this.positionValue += 8;
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, byte by) {
        UnsafeMemory.INSTANCE.putByte(this.getNativeAddress() + (long)index, by);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, short s) {
        short value = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? s : Short.reverseBytes(s)) : (this.littleEndian ? Short.reverseBytes(s) : s);
        UnsafeMemory.INSTANCE.putShort(this.getNativeAddress() + (long)index, value);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, int n) {
        int value = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? n : Integer.reverseBytes(n)) : (this.littleEndian ? Integer.reverseBytes(n) : n);
        UnsafeMemory.INSTANCE.putInt(this.getNativeAddress() + (long)index, value);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, long l) {
        long value = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? (this.littleEndian ? l : Long.reverseBytes(l)) : (this.littleEndian ? Long.reverseBytes(l) : l);
        UnsafeMemory.INSTANCE.putLong(this.getNativeAddress() + (long)index, value);
        return this;
    }

    @Override
    @NotNull
    public byte[] readByteArray(int size) {
        byte[] array = new byte[size];
        UnsafeMemory.INSTANCE.copyMemoryToArray(this.getNativeAddress() + (long)this.positionValue, array, 0, size);
        this.positionValue += size;
        return array;
    }

    @Override
    @NotNull
    public WriteBuffer writeBytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        UnsafeMemory.INSTANCE.copyMemoryFromArray(bytes, offset, this.getNativeAddress() + (long)this.positionValue, length);
        this.positionValue += length;
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeInts(@NotNull int[] ints, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        int i = offset;
        int end = offset + length;
        if (needsSwap) {
            while (i + 1 < end) {
                long swapped0 = (long)Integer.reverseBytes(ints[i]) & 0xFFFFFFFFL;
                long swapped1 = (long)Integer.reverseBytes(ints[i + 1]) & 0xFFFFFFFFL;
                UnsafeMemory.INSTANCE.putLong(addr, swapped0 | swapped1 << 32);
                addr += (long)8;
                i += 2;
            }
            if (i < end) {
                UnsafeMemory.INSTANCE.putInt(addr, Integer.reverseBytes(ints[i]));
                addr += (long)4;
                ++i;
            }
        } else {
            while (i + 1 < end) {
                long v0 = (long)ints[i] & 0xFFFFFFFFL;
                long v1 = (long)ints[i + 1] & 0xFFFFFFFFL;
                UnsafeMemory.INSTANCE.putLong(addr, v0 | v1 << 32);
                addr += (long)8;
                i += 2;
            }
            if (i < end) {
                UnsafeMemory.INSTANCE.putInt(addr, ints[i]);
                addr += (long)4;
                ++i;
            }
        }
        this.positionValue += length * 4;
        return this;
    }

    @Override
    public void readInts(@NotNull int[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        int i = offset;
        int end = offset + length;
        if (needsSwap) {
            while (i + 1 < end) {
                long longVal = UnsafeMemory.INSTANCE.getLong(addr);
                dest[i] = Integer.reverseBytes((int)longVal);
                dest[i + 1] = Integer.reverseBytes((int)(longVal >>> 32));
                addr += (long)8;
                i += 2;
            }
            if (i < end) {
                dest[i] = Integer.reverseBytes(UnsafeMemory.INSTANCE.getInt(addr));
                ++i;
            }
        } else {
            while (i + 1 < end) {
                long longVal = UnsafeMemory.INSTANCE.getLong(addr);
                dest[i] = (int)longVal;
                dest[i + 1] = (int)(longVal >>> 32);
                addr += (long)8;
                i += 2;
            }
            if (i < end) {
                dest[i] = UnsafeMemory.INSTANCE.getInt(addr);
                ++i;
            }
        }
        this.positionValue += length * 4;
    }

    @Override
    @NotNull
    public WriteBuffer writeShorts(@NotNull short[] shorts, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)shorts, (String)"shorts");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        int i = offset;
        int end = offset + length;
        if (needsSwap) {
            while (i + 3 < end) {
                long s0 = (long)Short.reverseBytes(shorts[i]) & 0xFFFFL;
                long s1 = (long)Short.reverseBytes(shorts[i + 1]) & 0xFFFFL;
                long s2 = (long)Short.reverseBytes(shorts[i + 2]) & 0xFFFFL;
                long s3 = (long)Short.reverseBytes(shorts[i + 3]) & 0xFFFFL;
                UnsafeMemory.INSTANCE.putLong(addr, s0 | s1 << 16 | s2 << 32 | s3 << 48);
                addr += (long)8;
                i += 4;
            }
            while (i < end) {
                UnsafeMemory.INSTANCE.putShort(addr, Short.reverseBytes(shorts[i]));
                addr += (long)2;
                ++i;
            }
        } else {
            while (i + 3 < end) {
                long s0 = (long)shorts[i] & 0xFFFFL;
                long s1 = (long)shorts[i + 1] & 0xFFFFL;
                long s2 = (long)shorts[i + 2] & 0xFFFFL;
                long s3 = (long)shorts[i + 3] & 0xFFFFL;
                UnsafeMemory.INSTANCE.putLong(addr, s0 | s1 << 16 | s2 << 32 | s3 << 48);
                addr += (long)8;
                i += 4;
            }
            while (i < end) {
                UnsafeMemory.INSTANCE.putShort(addr, shorts[i]);
                addr += (long)2;
                ++i;
            }
        }
        this.positionValue += length * 2;
        return this;
    }

    @Override
    public void readShorts(@NotNull short[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        int i = offset;
        int end = offset + length;
        if (needsSwap) {
            while (i + 3 < end) {
                long longVal = UnsafeMemory.INSTANCE.getLong(addr);
                dest[i] = Short.reverseBytes((short)longVal);
                dest[i + 1] = Short.reverseBytes((short)(longVal >>> 16));
                dest[i + 2] = Short.reverseBytes((short)(longVal >>> 32));
                dest[i + 3] = Short.reverseBytes((short)(longVal >>> 48));
                addr += (long)8;
                i += 4;
            }
            while (i < end) {
                dest[i] = Short.reverseBytes(UnsafeMemory.INSTANCE.getShort(addr));
                addr += (long)2;
                ++i;
            }
        } else {
            while (i + 3 < end) {
                long longVal = UnsafeMemory.INSTANCE.getLong(addr);
                dest[i] = (short)longVal;
                dest[i + 1] = (short)(longVal >>> 16);
                dest[i + 2] = (short)(longVal >>> 32);
                dest[i + 3] = (short)(longVal >>> 48);
                addr += (long)8;
                i += 4;
            }
            while (i < end) {
                dest[i] = UnsafeMemory.INSTANCE.getShort(addr);
                addr += (long)2;
                ++i;
            }
        }
        this.positionValue += length * 2;
    }

    @Override
    @NotNull
    public WriteBuffer writeLongs(@NotNull long[] longs, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)longs, (String)"longs");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        if (needsSwap) {
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                UnsafeMemory.INSTANCE.putLong(addr, Long.reverseBytes(longs[i]));
                addr += (long)8;
            }
        } else {
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                UnsafeMemory.INSTANCE.putLong(addr, longs[i]);
                addr += (long)8;
            }
        }
        this.positionValue += length * 8;
        return this;
    }

    @Override
    public void readLongs(@NotNull long[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        boolean needsSwap = Intrinsics.areEqual((Object)java.nio.ByteOrder.nativeOrder(), (Object)java.nio.ByteOrder.LITTLE_ENDIAN) != this.littleEndian;
        long addr = this.getNativeAddress() + (long)this.positionValue;
        if (needsSwap) {
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                dest[i] = Long.reverseBytes(UnsafeMemory.INSTANCE.getLong(addr));
                addr += (long)8;
            }
        } else {
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                dest[i] = UnsafeMemory.INSTANCE.getLong(addr);
                addr += (long)8;
            }
        }
        this.positionValue += length * 8;
    }

    @Override
    public void write(@NotNull ReadBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int size = buffer.remaining();
        ReadBuffer actual = ReadBufferKt.unwrapFully(buffer);
        if (!(actual instanceof UnsafeScopedBuffer)) {
            this.writeBytes(buffer.readByteArray(size));
            buffer.position(buffer.position() + size);
            return;
        }
        UnsafeMemory.INSTANCE.copyMemory(((UnsafeScopedBuffer)actual).getNativeAddress() + (long)((UnsafeScopedBuffer)actual).positionValue, this.getNativeAddress() + (long)this.positionValue, size);
        this.positionValue += size;
        buffer.position(buffer.position() + size);
    }

    @Override
    @NotNull
    public ReadBuffer slice() {
        return new UnsafeScopedBuffer(this.getScope(), this.getNativeAddress() + (long)this.positionValue, this.remaining(), this.getByteOrder());
    }

    private final ByteBuffer getByteBufferView() {
        if (!this.byteBufferViewChecked) {
            this.byteBufferViewChecked = true;
            this.byteBufferView = UnsafeMemory.INSTANCE.tryWrapAsDirectByteBuffer(this.getNativeAddress(), this.getCapacity());
        }
        return this.byteBufferView;
    }

    @Override
    @NotNull
    public String readString(int length, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        ByteBuffer view = this.getByteBufferView();
        if (view != null) {
            int finalPosition = this.positionValue + length;
            ((Buffer)view).position(this.positionValue);
            ((Buffer)view).limit(finalPosition);
            CharBuffer decoded = this.toJavaCharset(charset).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(view.slice());
            this.positionValue = finalPosition;
            String string = decoded.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        byte[] bytes = this.readByteArray(length);
        return new String(bytes, this.toJavaCharset(charset));
    }

    @Override
    @NotNull
    public WriteBuffer writeString(@NotNull CharSequence text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        ByteBuffer view = this.getByteBufferView();
        if (view != null) {
            CharsetEncoder encoder = CharsetEncoderHelperKt.toEncoder(charset);
            encoder.reset();
            ((Buffer)view).position(this.positionValue);
            ((Buffer)view).limit(this.getCapacity());
            encoder.encode(CharBuffer.wrap(text), view, true);
            this.positionValue = view.position();
            return this;
        }
        byte[] byArray = ((Object)text).toString().getBytes(this.toJavaCharset(charset));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        this.writeBytes(bytes);
        return this;
    }

    private final java.nio.charset.Charset toJavaCharset(Charset $this$toJavaCharset) {
        java.nio.charset.Charset charset;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toJavaCharset.ordinal()]) {
            case 1: {
                charset = Charsets.UTF_8;
                break;
            }
            case 2: {
                charset = Charsets.UTF_16;
                break;
            }
            case 3: {
                charset = Charsets.UTF_16BE;
                break;
            }
            case 4: {
                charset = Charsets.UTF_16LE;
                break;
            }
            case 5: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 6: {
                charset = Charsets.ISO_8859_1;
                break;
            }
            case 7: {
                java.nio.charset.Charset charset2 = java.nio.charset.Charset.forName("UTF-32");
                charset = charset2;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                break;
            }
            case 8: {
                java.nio.charset.Charset charset3 = java.nio.charset.Charset.forName("UTF-32BE");
                charset = charset3;
                Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(...)");
                break;
            }
            case 9: {
                java.nio.charset.Charset charset4 = java.nio.charset.Charset.forName("UTF-32LE");
                charset = charset4;
                Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"forName(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return charset;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Charset.values().length];
            try {
                nArray[Charset.UTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16BigEndian.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16LittleEndian.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ASCII.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ISOLatin1.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32BigEndian.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32LittleEndian.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

