/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BaseJvmBuffer;
import com.ditchoom.buffer.CharacterDecodingException;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.ManagedMemoryAccess;
import com.ditchoom.buffer.NativeMemoryAccessKt;
import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.ReadBufferKt;
import com.ditchoom.buffer.StreamingStringDecoder;
import com.ditchoom.buffer.StreamingStringDecoderConfig;
import com.ditchoom.buffer.StreamingStringDecoder_jvmCommonKt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ditchoom/buffer/JvmStreamingStringDecoder;", "Lcom/ditchoom/buffer/StreamingStringDecoder;", "config", "Lcom/ditchoom/buffer/StreamingStringDecoderConfig;", "<init>", "(Lcom/ditchoom/buffer/StreamingStringDecoderConfig;)V", "javaCharset", "Ljava/nio/charset/Charset;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "charBuffer", "Ljava/nio/CharBuffer;", "pendingLong", "", "pendingCount", "", "combinedBuffer", "Ljava/nio/ByteBuffer;", "decode", "buffer", "Lcom/ditchoom/buffer/ReadBuffer;", "destination", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getByteBuffer", "remaining", "getCombinedByteBuffer", "finish", "reset", "", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCoderResult", "result", "Ljava/nio/charset/CoderResult;", "position", "Companion", "buffer_release"})
final class JvmStreamingStringDecoder
implements StreamingStringDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamingStringDecoderConfig config;
    @NotNull
    private final java.nio.charset.Charset javaCharset;
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final CharBuffer charBuffer;
    private long pendingLong;
    private int pendingCount;
    @Nullable
    private ByteBuffer combinedBuffer;
    @NotNull
    private static final ByteBuffer EMPTY_BYTE_BUFFER;

    /*
     * WARNING - void declaration
     */
    public JvmStreamingStringDecoder(@NotNull StreamingStringDecoderConfig config) {
        void $this$decoder_u24lambda_u240;
        CharsetDecoder charsetDecoder;
        java.nio.charset.Charset charset;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        switch (WhenMappings.$EnumSwitchMapping$0[this.config.getCharset().ordinal()]) {
            case 1: {
                charset = Charsets.UTF_8;
                break;
            }
            case 2: {
                charset = Charsets.UTF_16;
                break;
            }
            case 3: {
                charset = Charsets.UTF_16BE;
                break;
            }
            case 4: {
                charset = Charsets.UTF_16LE;
                break;
            }
            case 5: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 6: {
                charset = Charsets.ISO_8859_1;
                break;
            }
            case 7: {
                charset = Charsets.INSTANCE.UTF32();
                break;
            }
            case 8: {
                charset = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case 9: {
                charset = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.javaCharset = charset;
        CharsetDecoder charsetDecoder2 = charsetDecoder = this.javaCharset.newDecoder();
        JvmStreamingStringDecoder jvmStreamingStringDecoder = this;
        boolean bl = false;
        $this$decoder_u24lambda_u240.onMalformedInput(StreamingStringDecoder_jvmCommonKt.access$toCodingErrorAction(this.config.getOnMalformedInput()));
        $this$decoder_u24lambda_u240.onUnmappableCharacter(StreamingStringDecoder_jvmCommonKt.access$toCodingErrorAction(this.config.getOnUnmappableCharacter()));
        CharsetDecoder charsetDecoder3 = charsetDecoder;
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder3, (String)"apply(...)");
        jvmStreamingStringDecoder.decoder = charsetDecoder3;
        CharBuffer charBuffer = CharBuffer.allocate(this.config.getCharBufferSize());
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"allocate(...)");
        this.charBuffer = charBuffer;
    }

    @Override
    public int decode(@NotNull ReadBuffer buffer, @NotNull Appendable destination) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int remaining = buffer.remaining();
        if (remaining == 0 && this.pendingCount == 0) {
            return 0;
        }
        int totalChars = 0;
        ByteBuffer byteBuffer = this.pendingCount > 0 ? this.getCombinedByteBuffer(buffer, remaining) : this.getByteBuffer(buffer, remaining);
        int startPosition = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            this.charBuffer.clear();
            CoderResult result = this.decoder.decode(byteBuffer, this.charBuffer, false);
            this.charBuffer.flip();
            if (this.charBuffer.hasRemaining()) {
                int count = this.charBuffer.remaining();
                destination.append(this.charBuffer);
                totalChars += count;
            }
            if (result.isUnderflow()) {
                int unconsumed = byteBuffer.remaining();
                if (unconsumed > 0) {
                    this.pendingCount = unconsumed;
                    this.pendingLong = 0L;
                    for (int i = 0; i < unconsumed; ++i) {
                        this.pendingLong |= ((long)byteBuffer.get() & 0xFFL) << i * 8;
                    }
                    break;
                }
                this.pendingCount = 0;
                break;
            }
            if (result.isOverflow() || !result.isMalformed() && !result.isUnmappable()) continue;
            this.pendingCount = 0;
            Intrinsics.checkNotNull((Object)result);
            this.handleCoderResult(result, buffer.position());
        }
        buffer.position(buffer.position() + remaining);
        return totalChars;
    }

    private final ByteBuffer getByteBuffer(ReadBuffer buffer, int remaining) {
        ReadBuffer actual = ReadBufferKt.unwrapFully(buffer);
        if (actual instanceof BaseJvmBuffer) {
            ByteBuffer bb = ((BaseJvmBuffer)actual).getByteBuffer().asReadOnlyBuffer();
            Intrinsics.checkNotNull((Object)bb, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)bb).position(buffer.position());
            ((Buffer)bb).limit(buffer.position() + remaining);
            return bb;
        }
        ManagedMemoryAccess managedAccess = NativeMemoryAccessKt.getManagedMemoryAccess(buffer);
        if (managedAccess != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(managedAccess.getBackingArray(), managedAccess.getArrayOffset() + buffer.position(), remaining);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }
        ByteBuffer cb = this.combinedBuffer;
        if (cb == null || cb.capacity() < remaining) {
            this.combinedBuffer = cb = ByteBuffer.allocate(Math.max(remaining, 8192));
        }
        ByteBuffer byteBuffer = cb;
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).clear();
        int startPos = buffer.position();
        for (int i = 0; i < remaining; ++i) {
            cb.put(buffer.get(startPos + i));
        }
        ByteBuffer byteBuffer2 = cb;
        Intrinsics.checkNotNull((Object)byteBuffer2, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer2).flip();
        return cb;
    }

    private final ByteBuffer getCombinedByteBuffer(ReadBuffer buffer, int remaining) {
        int totalSize = this.pendingCount + remaining;
        ByteBuffer cb = this.combinedBuffer;
        if (cb == null || cb.capacity() < totalSize) {
            this.combinedBuffer = cb = ByteBuffer.allocate(Math.max(totalSize, 8192));
        }
        ByteBuffer byteBuffer = cb;
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).clear();
        int n = this.pendingCount;
        for (int i = 0; i < n; ++i) {
            cb.put((byte)(this.pendingLong >>> i * 8 & 0xFFL));
        }
        this.pendingCount = 0;
        int startPos = buffer.position();
        for (int i = 0; i < remaining; ++i) {
            cb.put(buffer.get(startPos + i));
        }
        ByteBuffer byteBuffer2 = cb;
        Intrinsics.checkNotNull((Object)byteBuffer2, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer2).flip();
        return cb;
    }

    @Override
    public int finish(@NotNull Appendable destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int totalChars = 0;
        if (this.pendingCount > 0) {
            ByteBuffer cb = this.combinedBuffer;
            if (cb == null || cb.capacity() < this.pendingCount) {
                this.combinedBuffer = cb = ByteBuffer.allocate(Math.max(this.pendingCount, 8192));
            }
            ByteBuffer byteBuffer = cb;
            Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer).clear();
            int n = this.pendingCount;
            for (int i = 0; i < n; ++i) {
                cb.put((byte)(this.pendingLong >>> i * 8 & 0xFFL));
            }
            ByteBuffer byteBuffer2 = cb;
            Intrinsics.checkNotNull((Object)byteBuffer2, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer2).flip();
            ByteBuffer byteBuffer3 = cb;
            this.pendingCount = 0;
            this.charBuffer.clear();
            CoderResult result = this.decoder.decode(byteBuffer3, this.charBuffer, true);
            this.charBuffer.flip();
            if (this.charBuffer.hasRemaining()) {
                int count = this.charBuffer.remaining();
                destination.append(this.charBuffer);
                totalChars += count;
            }
            if (result.isMalformed() || result.isUnmappable()) {
                Intrinsics.checkNotNull((Object)result);
                this.handleCoderResult(result, -1);
            }
        } else {
            this.charBuffer.clear();
            this.decoder.decode(EMPTY_BYTE_BUFFER.duplicate(), this.charBuffer, true);
            this.charBuffer.flip();
            if (this.charBuffer.hasRemaining()) {
                int count = this.charBuffer.remaining();
                destination.append(this.charBuffer);
                totalChars += count;
            }
        }
        this.charBuffer.clear();
        CoderResult flushResult = this.decoder.flush(this.charBuffer);
        this.charBuffer.flip();
        if (this.charBuffer.hasRemaining()) {
            int count = this.charBuffer.remaining();
            destination.append(this.charBuffer);
            totalChars += count;
        }
        if (flushResult.isMalformed() || flushResult.isUnmappable()) {
            Intrinsics.checkNotNull((Object)flushResult);
            this.handleCoderResult(flushResult, -1);
        }
        return totalChars;
    }

    @Override
    public void reset() {
        this.decoder.reset();
        this.charBuffer.clear();
        this.pendingLong = 0L;
        this.pendingCount = 0;
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    private final void handleCoderResult(CoderResult result, int position) {
        if (result.isMalformed()) {
            throw new CharacterDecodingException("Malformed input of length " + result.length(), position);
        }
        if (result.isUnmappable()) {
            throw new CharacterDecodingException("Unmappable character of length " + result.length(), position);
        }
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        EMPTY_BYTE_BUFFER = byteBuffer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ditchoom/buffer/JvmStreamingStringDecoder$Companion;", "", "<init>", "()V", "EMPTY_BYTE_BUFFER", "Ljava/nio/ByteBuffer;", "buffer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Charset.values().length];
            try {
                nArray[Charset.UTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16BigEndian.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16LittleEndian.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ASCII.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ISOLatin1.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32LittleEndian.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32BigEndian.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

