/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer.stream;

import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.stream.BufferChunk;
import com.ditchoom.buffer.stream.BufferStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/ditchoom/buffer/stream/ReadBufferStream;", "Lcom/ditchoom/buffer/stream/BufferStream;", "source", "Lcom/ditchoom/buffer/ReadBuffer;", "chunkSize", "", "<init>", "(Lcom/ditchoom/buffer/ReadBuffer;I)V", "contentLength", "", "getContentLength", "()J", "forEachChunk", "", "handler", "Lkotlin/Function1;", "Lcom/ditchoom/buffer/stream/BufferChunk;", "buffer_release"})
final class ReadBufferStream
implements BufferStream {
    @NotNull
    private final ReadBuffer source;
    private final int chunkSize;
    private final long contentLength;

    public ReadBufferStream(@NotNull ReadBuffer source, int chunkSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.chunkSize = chunkSize;
        this.contentLength = this.source.remaining();
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void forEachChunk(@NotNull Function1<? super BufferChunk, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        long offset = 0L;
        int totalSize = this.source.remaining();
        while (this.source.remaining() > 0) {
            int remaining = this.source.remaining();
            int size = Math.min(this.chunkSize, remaining);
            boolean isLast = offset + (long)size >= (long)totalSize;
            int oldLimit = this.source.limit();
            this.source.setLimit(this.source.position() + size);
            ReadBuffer slice = this.source.slice();
            this.source.setLimit(oldLimit);
            this.source.position(this.source.position() + size);
            handler.invoke((Object)new BufferChunk(slice, isLast, offset));
            offset += (long)size;
        }
    }
}

