/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BufferScope;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.ScopedBuffer;
import com.ditchoom.buffer.UnsafeAllocator;
import com.ditchoom.buffer.UnsafeScopedBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/ditchoom/buffer/UnsafeBufferScope;", "Lcom/ditchoom/buffer/BufferScope;", "<init>", "()V", "allocations", "", "", "open", "", "isOpen", "()Z", "allocate", "Lcom/ditchoom/buffer/ScopedBuffer;", "size", "", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "allocateAligned", "alignment", "close", "", "buffer_release"})
@SourceDebugExtension(value={"SMAP\nUnsafeBufferScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBufferScope.kt\ncom/ditchoom/buffer/UnsafeBufferScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class UnsafeBufferScope
implements BufferScope {
    @NotNull
    private final List<Long> allocations = new ArrayList();
    private boolean open = true;

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    @NotNull
    public ScopedBuffer allocate(int size, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        if (!this.open) {
            boolean bl = false;
            String string = "BufferScope is closed";
            throw new IllegalStateException(string.toString());
        }
        long address = UnsafeAllocator.INSTANCE.allocateMemory(size);
        this.allocations.add(address);
        return new UnsafeScopedBuffer(this, address, size, byteOrder);
    }

    @Override
    @NotNull
    public ScopedBuffer allocateAligned(int size, int alignment, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        if (!this.open) {
            boolean $i$a$-check-UnsafeBufferScope$allocateAligned$22 = false;
            String $i$a$-check-UnsafeBufferScope$allocateAligned$22 = "BufferScope is closed";
            throw new IllegalStateException($i$a$-check-UnsafeBufferScope$allocateAligned$22.toString());
        }
        if (!(alignment > 0 && (alignment & alignment - 1) == 0)) {
            boolean bl = false;
            String string = "Alignment must be a positive power of 2, got: " + alignment;
            throw new IllegalArgumentException(string.toString());
        }
        long totalSize = (long)size + (long)alignment - 1L;
        long rawAddress = UnsafeAllocator.INSTANCE.allocateMemory(totalSize);
        this.allocations.add(rawAddress);
        long alignedAddress = rawAddress + (long)alignment - 1L & (long)(~(alignment - 1));
        return new UnsafeScopedBuffer(this, alignedAddress, size, byteOrder);
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            Iterator<Long> iterator = this.allocations.iterator();
            while (iterator.hasNext()) {
                long address = ((Number)iterator.next()).longValue();
                UnsafeAllocator.INSTANCE.freeMemory(address);
            }
            this.allocations.clear();
        }
    }
}

