/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.JvmBuffer;
import com.ditchoom.buffer.NativeMemoryAccess;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/ditchoom/buffer/DirectJvmBuffer;", "Lcom/ditchoom/buffer/JvmBuffer;", "Lcom/ditchoom/buffer/NativeMemoryAccess;", "byteBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "nativeAddress", "", "getNativeAddress", "()J", "nativeAddress$delegate", "Lkotlin/Lazy;", "nativeSize", "getNativeSize", "Companion", "buffer_release"})
@SourceDebugExtension(value={"SMAP\nDirectJvmBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectJvmBuffer.kt\ncom/ditchoom/buffer/DirectJvmBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class DirectJvmBuffer
extends JvmBuffer
implements NativeMemoryAccess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy nativeAddress$delegate;
    @NotNull
    private static final Lazy<Field> addressField$delegate = LazyKt.lazy(DirectJvmBuffer::addressField_delegate$lambda$0);

    public DirectJvmBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        super(byteBuffer);
        if (!byteBuffer.isDirect()) {
            boolean bl = false;
            String string = "DirectJvmBuffer requires a direct ByteBuffer";
            throw new IllegalArgumentException(string.toString());
        }
        this.nativeAddress$delegate = LazyKt.lazy(() -> DirectJvmBuffer.nativeAddress_delegate$lambda$0(byteBuffer));
    }

    @Override
    public long getNativeAddress() {
        Lazy lazy = this.nativeAddress$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @Override
    public long getNativeSize() {
        return this.getCapacity();
    }

    private static final long nativeAddress_delegate$lambda$0(ByteBuffer $byteBuffer) {
        return DirectJvmBuffer.Companion.getDirectBufferAddress($byteBuffer);
    }

    private static final Field addressField_delegate$lambda$0() {
        Field field;
        try {
            Field field2 = Buffer.class.getDeclaredField("address");
            field2.setAccessible(true);
        }
        catch (Exception e) {
            field = null;
        }
        return field;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/ditchoom/buffer/DirectJvmBuffer$Companion;", "", "<init>", "()V", "addressField", "Ljava/lang/reflect/Field;", "getAddressField", "()Ljava/lang/reflect/Field;", "addressField$delegate", "Lkotlin/Lazy;", "getDirectBufferAddress", "", "buffer", "Ljava/nio/ByteBuffer;", "buffer_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Field getAddressField() {
            Lazy lazy = addressField$delegate;
            return (Field)lazy.getValue();
        }

        private final long getDirectBufferAddress(ByteBuffer buffer) {
            Field field = this.getAddressField();
            if (field == null) {
                throw new UnsupportedOperationException("Cannot access native address on this Android version.");
            }
            return field.getLong(buffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

