/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer.stream;

import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.pool.BufferPool;
import com.ditchoom.buffer.pool.PooledBuffer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u0000 -2\u00020\u0001:\u0001-B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0006\u0010 \u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\u0016J\u000e\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\nJ\u0006\u0010)\u001a\u00020\fJ\u0010\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/ditchoom/buffer/stream/StreamProcessor;", "", "pool", "Lcom/ditchoom/buffer/pool/BufferPool;", "<init>", "(Lcom/ditchoom/buffer/pool/BufferPool;)V", "chunks", "Lkotlin/collections/ArrayDeque;", "Lcom/ditchoom/buffer/ReadBuffer;", "totalAvailable", "", "append", "", "chunk", "available", "peekByte", "", "offset", "peekShort", "", "peekInt", "peekLong", "", "peekMismatch", "pattern", "peekMatches", "", "findMismatchInLong", "a", "b", "findMismatchInInt", "findMismatchInShort", "readByte", "readUnsignedByte", "readShort", "readInt", "readLong", "readBuffer", "size", "skip", "count", "release", "removeChunkIfEmpty", "releaseIfPooled", "buffer", "Companion", "buffer_release"})
@SourceDebugExtension(value={"SMAP\nBufferStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferStream.kt\ncom/ditchoom/buffer/stream/StreamProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n1#2:485\n*E\n"})
public final class StreamProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferPool pool;
    @NotNull
    private final ArrayDeque<ReadBuffer> chunks;
    private int totalAvailable;

    private StreamProcessor(BufferPool pool) {
        this.pool = pool;
        this.chunks = new ArrayDeque();
    }

    public final void append(@NotNull ReadBuffer chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.remaining() > 0) {
            this.chunks.addLast((Object)chunk);
            this.totalAvailable += chunk.remaining();
        }
    }

    public final int available() {
        return this.totalAvailable;
    }

    public final byte peekByte(int offset) {
        if (!(this.totalAvailable > offset)) {
            boolean bl = false;
            String string = "Not enough data: need " + (offset + 1) + ", have " + this.totalAvailable;
            throw new IllegalArgumentException(string.toString());
        }
        int remaining = offset;
        for (ReadBuffer chunk : this.chunks) {
            if (remaining < chunk.remaining()) {
                return chunk.get(chunk.position() + remaining);
            }
            remaining -= chunk.remaining();
        }
        throw new IllegalStateException("Unexpected end of data");
    }

    public static /* synthetic */ byte peekByte$default(StreamProcessor streamProcessor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamProcessor.peekByte(n);
    }

    public final short peekShort(int offset) {
        if (!(this.totalAvailable >= offset + 2)) {
            boolean bl = false;
            String string = "Not enough data for Short at offset " + offset;
            throw new IllegalArgumentException(string.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= offset + 2) {
            return chunk.getShort(chunk.position() + offset);
        }
        return (short)((this.peekByte(offset) & 0xFF) << 8 | this.peekByte(offset + 1) & 0xFF);
    }

    public static /* synthetic */ short peekShort$default(StreamProcessor streamProcessor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamProcessor.peekShort(n);
    }

    public final int peekInt(int offset) {
        if (!(this.totalAvailable >= offset + 4)) {
            boolean bl = false;
            String string = "Not enough data for Int at offset " + offset;
            throw new IllegalArgumentException(string.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= offset + 4) {
            return chunk.getInt(chunk.position() + offset);
        }
        return (this.peekByte(offset) & 0xFF) << 24 | (this.peekByte(offset + 1) & 0xFF) << 16 | (this.peekByte(offset + 2) & 0xFF) << 8 | this.peekByte(offset + 3) & 0xFF;
    }

    public static /* synthetic */ int peekInt$default(StreamProcessor streamProcessor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamProcessor.peekInt(n);
    }

    public final long peekLong(int offset) {
        if (!(this.totalAvailable >= offset + 8)) {
            boolean bl = false;
            String string = "Not enough data for Long at offset " + offset;
            throw new IllegalArgumentException(string.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= offset + 8) {
            return chunk.getLong(chunk.position() + offset);
        }
        return ((long)this.peekByte(offset) & 0xFFL) << 56 | ((long)this.peekByte(offset + 1) & 0xFFL) << 48 | ((long)this.peekByte(offset + 2) & 0xFFL) << 40 | ((long)this.peekByte(offset + 3) & 0xFFL) << 32 | ((long)this.peekByte(offset + 4) & 0xFFL) << 24 | ((long)this.peekByte(offset + 5) & 0xFFL) << 16 | ((long)this.peekByte(offset + 6) & 0xFFL) << 8 | (long)this.peekByte(offset + 7) & 0xFFL;
    }

    public static /* synthetic */ long peekLong$default(StreamProcessor streamProcessor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamProcessor.peekLong(n);
    }

    public final int peekMismatch(@NotNull ReadBuffer pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int patternSize = pattern.remaining();
        if (this.totalAvailable < patternSize) {
            return Math.min(this.totalAvailable, patternSize);
        }
        if (patternSize == 0) {
            return -1;
        }
        int patternPos = pattern.position();
        ReadBuffer firstChunk = (ReadBuffer)this.chunks.first();
        if (firstChunk.remaining() >= patternSize) {
            int chunkPos = firstChunk.position();
            int offset = 0;
            while (offset + 8 <= patternSize) {
                long patternLong;
                long chunkLong = firstChunk.getLong(chunkPos + offset);
                if (chunkLong != (patternLong = pattern.getLong(patternPos + offset))) {
                    return offset + this.findMismatchInLong(chunkLong, patternLong);
                }
                offset += 8;
            }
            if (offset + 4 <= patternSize) {
                int patternInt;
                int chunkInt = firstChunk.getInt(chunkPos + offset);
                if (chunkInt != (patternInt = pattern.getInt(patternPos + offset))) {
                    return offset + this.findMismatchInInt(chunkInt, patternInt);
                }
                offset += 4;
            }
            if (offset + 2 <= patternSize) {
                short patternShort;
                short chunkShort = firstChunk.getShort(chunkPos + offset);
                if (chunkShort != (patternShort = pattern.getShort(patternPos + offset))) {
                    return offset + this.findMismatchInShort(chunkShort, patternShort);
                }
                offset += 2;
            }
            if (offset < patternSize && firstChunk.get(chunkPos + offset) != pattern.get(patternPos + offset)) {
                return offset;
            }
            return -1;
        }
        for (int i = 0; i < patternSize; ++i) {
            if (this.peekByte(i) == pattern.get(patternPos + i)) continue;
            return i;
        }
        return -1;
    }

    public final boolean peekMatches(@NotNull ReadBuffer pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.peekMismatch(pattern) < 0;
    }

    private final int findMismatchInLong(long a, long b) {
        long xor = a ^ b;
        return Long.numberOfLeadingZeros(xor) / 8;
    }

    private final int findMismatchInInt(int a, int b) {
        int xor = a ^ b;
        return Integer.numberOfLeadingZeros(xor) / 8;
    }

    private final int findMismatchInShort(short a, short b) {
        int xor = (a ^ b) & 0xFFFF;
        return (Integer.numberOfLeadingZeros(xor) - 16) / 8;
    }

    public final byte readByte() {
        if (!(this.totalAvailable >= 1)) {
            boolean $i$a$-require-StreamProcessor$readByte$22 = false;
            String $i$a$-require-StreamProcessor$readByte$22 = "No data available";
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readByte$22.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        byte by = chunk.readByte();
        int n = this.totalAvailable;
        this.totalAvailable = n + -1;
        this.removeChunkIfEmpty(chunk);
        return by;
    }

    public final int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public final short readShort() {
        if (!(this.totalAvailable >= 2)) {
            boolean $i$a$-require-StreamProcessor$readShort$22 = false;
            String $i$a$-require-StreamProcessor$readShort$22 = "Not enough data for Short";
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readShort$22.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= 2) {
            short value = chunk.readShort();
            this.totalAvailable -= 2;
            this.removeChunkIfEmpty(chunk);
            return value;
        }
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public final int readInt() {
        if (!(this.totalAvailable >= 4)) {
            boolean $i$a$-require-StreamProcessor$readInt$22 = false;
            String $i$a$-require-StreamProcessor$readInt$22 = "Not enough data for Int";
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readInt$22.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= 4) {
            int value = chunk.readInt();
            this.totalAvailable -= 4;
            this.removeChunkIfEmpty(chunk);
            return value;
        }
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public final long readLong() {
        if (!(this.totalAvailable >= 8)) {
            boolean $i$a$-require-StreamProcessor$readLong$22 = false;
            String $i$a$-require-StreamProcessor$readLong$22 = "Not enough data for Long";
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readLong$22.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.first();
        if (chunk.remaining() >= 8) {
            long value = chunk.readLong();
            this.totalAvailable -= 8;
            this.removeChunkIfEmpty(chunk);
            return value;
        }
        return ((long)this.readByte() & 0xFFL) << 56 | ((long)this.readByte() & 0xFFL) << 48 | ((long)this.readByte() & 0xFFL) << 40 | ((long)this.readByte() & 0xFFL) << 32 | ((long)this.readByte() & 0xFFL) << 24 | ((long)this.readByte() & 0xFFL) << 16 | ((long)this.readByte() & 0xFFL) << 8 | (long)this.readByte() & 0xFFL;
    }

    @NotNull
    public final ReadBuffer readBuffer(int size) {
        if (!(this.totalAvailable >= size)) {
            boolean $i$a$-require-StreamProcessor$readBuffer$32 = false;
            String $i$a$-require-StreamProcessor$readBuffer$32 = "Not enough data: need " + size + ", have " + this.totalAvailable;
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readBuffer$32.toString());
        }
        if (!(!((Collection)this.chunks).isEmpty() || size == 0)) {
            boolean $i$a$-require-StreamProcessor$readBuffer$42 = false;
            String $i$a$-require-StreamProcessor$readBuffer$42 = "No chunks available";
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$readBuffer$42.toString());
        }
        ReadBuffer chunk = (ReadBuffer)this.chunks.firstOrNull();
        if (chunk == null || size == 0) {
            PooledBuffer empty = this.pool.acquire(0);
            empty.resetForRead();
            return empty;
        }
        if (chunk.remaining() >= size) {
            int oldLimit = chunk.limit();
            chunk.setLimit(chunk.position() + size);
            ReadBuffer slice = chunk.slice();
            chunk.setLimit(oldLimit);
            chunk.position(chunk.position() + size);
            this.totalAvailable -= size;
            this.removeChunkIfEmpty(chunk);
            return slice;
        }
        PooledBuffer merged = this.pool.acquire(size);
        int remaining = size;
        while (remaining > 0 && !((Collection)this.chunks).isEmpty()) {
            ReadBuffer currentChunk = (ReadBuffer)this.chunks.first();
            int toCopy = Math.min(remaining, currentChunk.remaining());
            int oldLimit = currentChunk.limit();
            currentChunk.setLimit(currentChunk.position() + toCopy);
            merged.write(currentChunk);
            currentChunk.setLimit(oldLimit);
            remaining -= toCopy;
            this.totalAvailable -= toCopy;
            this.removeChunkIfEmpty(currentChunk);
        }
        merged.resetForRead();
        return merged;
    }

    public final void skip(int count) {
        if (!(this.totalAvailable >= count)) {
            boolean $i$a$-require-StreamProcessor$skip$22 = false;
            String $i$a$-require-StreamProcessor$skip$22 = "Not enough data to skip: need " + count + ", have " + this.totalAvailable;
            throw new IllegalArgumentException($i$a$-require-StreamProcessor$skip$22.toString());
        }
        int remaining = count;
        while (remaining > 0 && !((Collection)this.chunks).isEmpty()) {
            ReadBuffer chunk = (ReadBuffer)this.chunks.first();
            int toSkip = Math.min(remaining, chunk.remaining());
            chunk.position(chunk.position() + toSkip);
            remaining -= toSkip;
            this.totalAvailable -= toSkip;
            this.removeChunkIfEmpty(chunk);
        }
    }

    public final void release() {
        for (ReadBuffer chunk : this.chunks) {
            this.releaseIfPooled(chunk);
        }
        this.chunks.clear();
        this.totalAvailable = 0;
    }

    private final void removeChunkIfEmpty(ReadBuffer chunk) {
        if (chunk.remaining() == 0) {
            this.chunks.removeFirst();
            this.releaseIfPooled(chunk);
        }
    }

    private final void releaseIfPooled(ReadBuffer buffer) {
        if (buffer instanceof PooledBuffer) {
            ((PooledBuffer)buffer).release();
        }
    }

    public /* synthetic */ StreamProcessor(BufferPool pool, DefaultConstructorMarker $constructor_marker) {
        this(pool);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/ditchoom/buffer/stream/StreamProcessor$Companion;", "", "<init>", "()V", "create", "Lcom/ditchoom/buffer/stream/StreamProcessor;", "pool", "Lcom/ditchoom/buffer/pool/BufferPool;", "buffer_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamProcessor create(@NotNull BufferPool pool) {
            Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
            return new StreamProcessor(pool, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

