/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import android.os.Build;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.ditchoom.buffer.BaseJvmBuffer;
import com.ditchoom.buffer.ParcelableSharedMemoryBuffer;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/ditchoom/buffer/JvmBuffer;", "Lcom/ditchoom/buffer/BaseJvmBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "CREATOR", "buffer_release"})
public class JvmBuffer
extends BaseJvmBuffer {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final ByteBuffer buffer;

    public JvmBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer, null, 2, null);
        this.buffer = buffer;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (this instanceof ParcelableSharedMemoryBuffer) {
            dest.writeByte((byte)1);
            return;
        }
        dest.writeByte((byte)0);
        dest.writeInt(this.getByteBuffer().position());
        dest.writeInt(this.getByteBuffer().limit());
        if (this.getByteBuffer().isDirect()) {
            dest.writeByte((byte)1);
        } else {
            dest.writeByte((byte)0);
        }
        this.getByteBuffer().position(0);
        this.getByteBuffer().limit(this.getByteBuffer().capacity());
        ParcelFileDescriptor[] parcelFileDescriptorArray = Build.VERSION.SDK_INT >= 19 ? ParcelFileDescriptor.createReliablePipe() : ParcelFileDescriptor.createPipe();
        Intrinsics.checkNotNull((Object)parcelFileDescriptorArray);
        ParcelFileDescriptor readFileDescriptor = parcelFileDescriptorArray[0];
        ParcelFileDescriptor writeFileDescriptor = parcelFileDescriptorArray[1];
        readFileDescriptor.writeToParcel(dest, 0);
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("IPC Write Channel Jvm Buffer")));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(writeFileDescriptor, readFileDescriptor, scope, this, null){
            int label;
            final /* synthetic */ ParcelFileDescriptor $writeFileDescriptor;
            final /* synthetic */ ParcelFileDescriptor $readFileDescriptor;
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ JvmBuffer this$0;
            {
                this.$writeFileDescriptor = $writeFileDescriptor;
                this.$readFileDescriptor = $readFileDescriptor;
                this.$scope = $scope;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Closeable closeable = new FileOutputStream(this.$writeFileDescriptor.getFileDescriptor()).getChannel();
                        JvmBuffer jvmBuffer = this.this$0;
                        Throwable throwable = null;
                        try {
                            FileChannel writeChannel = (FileChannel)closeable;
                            boolean bl = false;
                            int n = writeChannel.write(jvmBuffer.getBuffer());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        this.$writeFileDescriptor.close();
                        this.$readFileDescriptor.close();
                        CoroutineScopeKt.cancel$default((CoroutineScope)this.$scope, null, (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/ditchoom/buffer/JvmBuffer$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/ditchoom/buffer/JvmBuffer;", "<init>", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/ditchoom/buffer/JvmBuffer;", "buffer_release"})
    @SourceDebugExtension(value={"SMAP\nJvmBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuffer.kt\ncom/ditchoom/buffer/JvmBuffer$CREATOR\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class CREATOR
    implements Parcelable.Creator<JvmBuffer> {
        private CREATOR() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public JvmBuffer createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            int p = parcel.dataPosition();
            if (parcel.readByte() == 1) {
                parcel.setDataPosition(p);
                return ParcelableSharedMemoryBuffer.CREATOR.createFromParcel(parcel);
            }
            int position = parcel.readInt();
            int limit = parcel.readInt();
            boolean isDirect = parcel.readByte() == 1;
            ByteBuffer buffer = isDirect ? ByteBuffer.allocateDirect(limit) : ByteBuffer.allocate(limit);
            Closeable closeable = (Closeable)ParcelFileDescriptor.CREATOR.createFromParcel(parcel);
            Throwable throwable = null;
            try {
                int n;
                ParcelFileDescriptor pfd = (ParcelFileDescriptor)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileInputStream(pfd.getFileDescriptor()).getChannel();
                Throwable throwable2 = null;
                try {
                    FileChannel readChannel = (FileChannel)closeable2;
                    boolean bl2 = false;
                    n = readChannel.read(buffer);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                int n2 = n;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            buffer.position(position);
            buffer.limit(limit);
            Intrinsics.checkNotNull((Object)buffer);
            return new JvmBuffer(buffer);
        }

        @NotNull
        public JvmBuffer[] newArray(int size) {
            return new JvmBuffer[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

