/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion.gradle.plugin.increment;

import com.jdroid.java.utils.FileUtils;
import com.semanticversion.Version;
import com.semanticversion.VersionIncrementType;
import com.semanticversion.gradle.plugin.commons.GitHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ji\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/semanticversion/gradle/plugin/increment/IncrementVersionHelper;", "", "()V", "increment", "Lcom/semanticversion/Version;", "versionFile", "Ljava/io/File;", "versionIncrementType", "Lcom/semanticversion/VersionIncrementType;", "versionIncrementBranch", "", "maximumMajorVersion", "", "maximumMinorVersion", "maximumPatchVersion", "commitMessagePrefix", "gitUserName", "gitUserEmail", "gitHelper", "Lcom/semanticversion/gradle/plugin/commons/GitHelper;", "(Ljava/io/File;Lcom/semanticversion/VersionIncrementType;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/semanticversion/gradle/plugin/commons/GitHelper;)Lcom/semanticversion/Version;", "semantic-version-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nIncrementVersionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementVersionHelper.kt\ncom/semanticversion/gradle/plugin/increment/IncrementVersionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1851#2,2:64\n*S KotlinDebug\n*F\n+ 1 IncrementVersionHelper.kt\ncom/semanticversion/gradle/plugin/increment/IncrementVersionHelper\n*L\n27#1:64,2\n*E\n"})
public final class IncrementVersionHelper {
    @NotNull
    public static final IncrementVersionHelper INSTANCE = new IncrementVersionHelper();

    private IncrementVersionHelper() {
    }

    @NotNull
    public final Version increment(@NotNull File versionFile, @NotNull VersionIncrementType versionIncrementType, @Nullable String versionIncrementBranch, @Nullable Integer maximumMajorVersion, @Nullable Integer maximumMinorVersion, @Nullable Integer maximumPatchVersion, @Nullable String commitMessagePrefix, @Nullable String gitUserName, @Nullable String gitUserEmail, @NotNull GitHelper gitHelper) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        Intrinsics.checkNotNullParameter((Object)versionIncrementType, (String)"versionIncrementType");
        Intrinsics.checkNotNullParameter((Object)gitHelper, (String)"gitHelper");
        Pattern versionPattern = Pattern.compile("^\\s?version\\s?=\\s?[\"'](.+)[\"']");
        List lines = new ArrayList();
        Version newVersion = null;
        List list = FileUtils.readLines((File)versionFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readLines(versionFile)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (newVersion == null) {
                Matcher versionMatcher = versionPattern.matcher(line);
                if (versionMatcher.find()) {
                    String versionText = versionMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)versionText, (String)"versionText");
                    newVersion = new Version(versionText, maximumMajorVersion, maximumMinorVersion, maximumPatchVersion);
                    versionIncrementType.increment(newVersion);
                    String newLineContent = versionMatcher.replaceFirst("version = \"" + newVersion + '\"');
                    Intrinsics.checkNotNullExpressionValue((Object)newLineContent, (String)"newLineContent");
                    lines.add(newLineContent);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
                lines.add(line);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            lines.add(line);
        }
        if (newVersion != null) {
            FileUtils.writeLines((File)versionFile, (List)lines);
            if (versionIncrementBranch != null) {
                CharSequence charSequence = gitUserName;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    gitHelper.configUserName(gitUserName);
                }
                if (!((charSequence = (CharSequence)gitUserEmail) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    gitHelper.configUserEmail(gitUserEmail);
                }
                String string = versionFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionFile.absolutePath");
                gitHelper.add(string);
                gitHelper.diffHead();
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = commitMessagePrefix;
                if (string2 == null) {
                    string2 = "";
                }
                gitHelper.commit(stringBuilder.append(string2).append("Changed project version to v").append(newVersion).toString());
                gitHelper.push(versionIncrementBranch);
            }
        } else {
            throw new RuntimeException("Version not defined on " + versionFile.getAbsolutePath());
        }
        return newVersion;
    }
}

