/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion.gradle.plugin.commons;

import com.semanticversion.gradle.plugin.commons.CommandExecutor;
import com.semanticversion.gradle.plugin.commons.GitHelper;
import com.semanticversion.gradle.plugin.commons.PropertyResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/semanticversion/gradle/plugin/commons/GitHelperImpl;", "Lcom/semanticversion/gradle/plugin/commons/GitHelper;", "propertyResolver", "Lcom/semanticversion/gradle/plugin/commons/PropertyResolver;", "commandExecutor", "Lcom/semanticversion/gradle/plugin/commons/CommandExecutor;", "(Lcom/semanticversion/gradle/plugin/commons/PropertyResolver;Lcom/semanticversion/gradle/plugin/commons/CommandExecutor;)V", "add", "", "filePath", "", "commit", "message", "configUserEmail", "userEmail", "configUserName", "userName", "diffHead", "getGitBranch", "push", "headBranch", "semantic-version-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGitHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHelperImpl.kt\ncom/semanticversion/gradle/plugin/commons/GitHelperImpl\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,45:1\n107#2:46\n79#2,22:47\n*S KotlinDebug\n*F\n+ 1 GitHelperImpl.kt\ncom/semanticversion/gradle/plugin/commons/GitHelperImpl\n*L\n11#1:46\n11#1:47,22\n*E\n"})
public final class GitHelperImpl
implements GitHelper {
    @NotNull
    private final PropertyResolver propertyResolver;
    @NotNull
    private final CommandExecutor commandExecutor;

    public GitHelperImpl(@NotNull PropertyResolver propertyResolver, @NotNull CommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.propertyResolver = propertyResolver;
        this.commandExecutor = commandExecutor;
    }

    @Override
    @Nullable
    public String getGitBranch() {
        String gitBranch = this.propertyResolver.getStringProp("GIT_BRANCH", null);
        CharSequence charSequence = gitBranch;
        if (charSequence == null || charSequence.length() == 0) {
            gitBranch = CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git symbolic-ref HEAD", null, false, false, false, 26, null).getStandardOutput();
        }
        String $this$trim$iv = gitBranch;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        gitBranch = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        gitBranch = StringsKt.replace$default((String)gitBranch, (String)"origin/", (String)"", (boolean)false, (int)4, null);
        gitBranch = StringsKt.replace$default((String)gitBranch, (String)"refs/heads/", (String)"", (boolean)false, (int)4, null);
        gitBranch = StringsKt.replace$default((String)gitBranch, (String)"refs/tags/", (String)"", (boolean)false, (int)4, null);
        return gitBranch;
    }

    @Override
    public void configUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git config user.name " + userName, null, false, false, false, 30, null);
    }

    @Override
    public void configUserEmail(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git config user.email " + userEmail, null, false, false, false, 30, null);
    }

    @Override
    public void diffHead() {
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git diff HEAD", null, false, false, false, 30, null);
    }

    @Override
    public void commit(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git commit -m \"" + message + '\"', null, false, false, false, 30, null);
    }

    @Override
    public void push(@NotNull String headBranch) {
        Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git push origin HEAD:" + headBranch, null, false, false, false, 30, null);
    }

    @Override
    public void add(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        CommandExecutor.DefaultImpls.execute$default(this.commandExecutor, "git add " + filePath, null, false, false, false, 30, null);
    }
}

