/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion.gradle.plugin.commons;

import com.semanticversion.gradle.plugin.commons.CommandExecutor;
import com.semanticversion.gradle.plugin.commons.ExtendedExecResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/semanticversion/gradle/plugin/commons/CommandExecutorImpl;", "Lcom/semanticversion/gradle/plugin/commons/CommandExecutor;", "project", "Lorg/gradle/api/Project;", "logLevel", "Lorg/gradle/api/logging/LogLevel;", "(Lorg/gradle/api/Project;Lorg/gradle/api/logging/LogLevel;)V", "execute", "Lcom/semanticversion/gradle/plugin/commons/ExtendedExecResult;", "command", "", "workingDirectory", "Ljava/io/File;", "logStandardOutput", "", "logErrorOutput", "ignoreExitValue", "log", "", "message", "semantic-version-gradle-plugin"})
public final class CommandExecutorImpl
implements CommandExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final LogLevel logLevel;

    public CommandExecutorImpl(@NotNull Project project, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.project = project;
        this.logLevel = logLevel;
    }

    @Override
    @NotNull
    public ExtendedExecResult execute(@NotNull String command, @Nullable File workingDirectory, boolean logStandardOutput, boolean logErrorOutput, boolean ignoreExitValue) {
        File file;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (logStandardOutput) {
            this.log("Executing command: " + command);
        }
        if ((file = workingDirectory) == null) {
            file = this.project.getRootProject().getProjectDir();
        }
        File workDir = file;
        ByteArrayOutputStream standardOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorOutputStream = new ByteArrayOutputStream();
        ExecResult execResult2 = this.project.exec(arg_0 -> CommandExecutorImpl.execute$lambda$0((Function1)new Function1<ExecSpec, Unit>(workDir, command, standardOutputStream, errorOutputStream){
            final /* synthetic */ File $workDir;
            final /* synthetic */ String $command;
            final /* synthetic */ ByteArrayOutputStream $standardOutputStream;
            final /* synthetic */ ByteArrayOutputStream $errorOutputStream;
            {
                this.$workDir = $workDir;
                this.$command = $command;
                this.$standardOutputStream = $standardOutputStream;
                this.$errorOutputStream = $errorOutputStream;
                super(1);
            }

            public final void invoke(ExecSpec execSpec) {
                execSpec.setWorkingDir(this.$workDir);
                String[] stringArray = Commandline.translateCommandline((String)this.$command);
                execSpec.setCommandLine((Object[])Arrays.copyOf(stringArray, stringArray.length));
                execSpec.setIgnoreExitValue(true);
                execSpec.setStandardOutput((OutputStream)this.$standardOutputStream);
                execSpec.setErrorOutput((OutputStream)this.$errorOutputStream);
            }
        }, arg_0));
        if (logStandardOutput && standardOutputStream.size() > 0) {
            String string = standardOutputStream.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"standardOutputStream.toString()");
            this.log(string);
        }
        if (logErrorOutput && errorOutputStream.size() > 0) {
            this.project.getLogger().error(errorOutputStream.toString());
        }
        if (!ignoreExitValue && execResult2.getExitValue() > 0) {
            throw new RuntimeException("Failed execution of command: " + command);
        }
        Intrinsics.checkNotNullExpressionValue((Object)execResult2, (String)"execResult");
        return new ExtendedExecResult(execResult2, standardOutputStream, errorOutputStream);
    }

    private final void log(String message) {
        this.project.getLogger().log(this.logLevel, message);
    }

    private static final void execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

