/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.annotation.JSONCreator;
import shade.com.alibaba.fastjson2.annotation.JSONType;

@JSONType(deserializeFeatures={JSONReader.Feature.SupportAutoType}, typeName="java.lang.reflect.ParameterizedType")
public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;

    @JSONCreator
    public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
        this.rawType = rawType;
    }

    public ParameterizedTypeImpl(Type rawType, Type ... actualTypeArguments) {
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = null;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
        if (!Arrays.equals(this.actualTypeArguments, that.actualTypeArguments)) {
            return false;
        }
        if (!Objects.equals(this.ownerType, that.ownerType)) {
            return false;
        }
        return Objects.equals(this.rawType, that.rawType);
    }

    public int hashCode() {
        int result = this.actualTypeArguments != null ? Arrays.hashCode(this.actualTypeArguments) : 0;
        result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
        result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
        return result;
    }
}

