/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.schema;

import shade.com.alibaba.fastjson2.JSONArray;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONObject;
import shade.com.alibaba.fastjson2.schema.Any;
import shade.com.alibaba.fastjson2.schema.ArraySchema;
import shade.com.alibaba.fastjson2.schema.BooleanSchema;
import shade.com.alibaba.fastjson2.schema.IntegerSchema;
import shade.com.alibaba.fastjson2.schema.JSONSchema;
import shade.com.alibaba.fastjson2.schema.NumberSchema;
import shade.com.alibaba.fastjson2.schema.ObjectSchema;
import shade.com.alibaba.fastjson2.schema.StringSchema;
import shade.com.alibaba.fastjson2.schema.ValidateResult;

final class AllOf
extends JSONSchema {
    final JSONSchema[] items;

    public AllOf(JSONSchema[] items) {
        super(null, null);
        this.items = items;
    }

    public AllOf(JSONObject input, JSONSchema parent) {
        super(input);
        JSONArray items = input.getJSONArray("allOf");
        if (items == null || items.isEmpty()) {
            throw new JSONException("allOf not found");
        }
        this.items = new JSONSchema[items.size()];
        JSONSchema.Type type = null;
        for (int i = 0; i < this.items.length; ++i) {
            JSONSchema itemSchema = null;
            Object item = items.get(i);
            if (item instanceof Boolean) {
                itemSchema = (Boolean)item != false ? Any.INSTANCE : Any.NOT_ANY;
            } else {
                JSONObject itemObject = (JSONObject)item;
                if (!itemObject.containsKey("type") && type != null) {
                    switch (type) {
                        case String: {
                            itemSchema = new StringSchema(itemObject);
                            break;
                        }
                        case Integer: {
                            itemSchema = new IntegerSchema(itemObject);
                            break;
                        }
                        case Number: {
                            itemSchema = new NumberSchema(itemObject);
                            break;
                        }
                        case Boolean: {
                            itemSchema = new BooleanSchema(itemObject);
                            break;
                        }
                        case Array: {
                            itemSchema = new ArraySchema(itemObject, null);
                            break;
                        }
                        case Object: {
                            itemSchema = new ObjectSchema(itemObject);
                            break;
                        }
                    }
                }
                if (itemSchema == null) {
                    itemSchema = JSONSchema.of(itemObject, parent);
                }
            }
            type = itemSchema.getType();
            this.items[i] = itemSchema;
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.AllOf;
    }

    @Override
    public ValidateResult validate(Object value) {
        for (JSONSchema item : this.items) {
            ValidateResult result = item.validate(value);
            if (result.isSuccess()) continue;
            return result;
        }
        return SUCCESS;
    }
}

