/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.reflect.Method;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReaderObject;
import shade.com.alibaba.fastjson2.schema.JSONSchema;
import shade.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderBoolValueMethod<T>
extends FieldReaderObject<T> {
    FieldReaderBoolValueMethod(String fieldName, int ordinal, long features, String format, Boolean defaultValue, JSONSchema schema, Method method) {
        super(fieldName, Boolean.TYPE, Boolean.TYPE, ordinal, features, format, null, defaultValue, schema, method, null, null);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        boolean fieldValue = jsonReader.readBoolValue();
        try {
            this.method.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        boolean fieldValue = jsonReader.readBoolValue();
        try {
            this.method.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        boolean booleanValue = TypeUtils.toBooleanValue(value);
        try {
            this.method.invoke(object, booleanValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBool();
    }
}

