/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.protocol;

import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    APPLICATION_JSON("application/json");

    private final String contentType;
    private static final Map<String, ContentType> MAPPING;

    private ContentType(String contentType) {
        this.contentType = contentType;
    }

    public static ContentType of(String contentType) {
        if (contentType == null) {
            return null;
        }
        return MAPPING.get(contentType.toLowerCase().trim());
    }

    public String getContentType() {
        return this.contentType;
    }

    static {
        MAPPING = new HashMap<String, ContentType>();
        for (ContentType value : ContentType.values()) {
            MAPPING.put(value.contentType, value);
        }
    }
}

