/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import com.dingtalk.open.app.stream.network.api.ClientConnectionListener;
import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.dingtalk.open.app.stream.network.ws.ProtocolFrameHandler;
import com.dingtalk.open.app.stream.network.ws.WebSocketContext;
import com.dingtalk.open.app.stream.protocol.DefaultProtocolRequestFacade;
import com.dingtalk.open.app.stream.protocol.ProtocolRequest;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.channel.SimpleChannelInboundHandler;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;

public class NettyClientHandler
extends SimpleChannelInboundHandler<ProtocolRequest> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(ProtocolFrameHandler.class);
    private final ClientConnectionListener listener;
    private final String connectionId;

    public NettyClientHandler(String connectionId, ClientConnectionListener listener) {
        this.connectionId = connectionId;
        this.listener = listener;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ProtocolRequest request) throws Exception {
        this.listener.receive(new WebSocketContext(this.connectionId, new DefaultProtocolRequestFacade(request), ctx));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("[DingTalk] connection is closed, connectionId={}", this.connectionId);
        this.listener.onDisConnection(this.connectionId);
        super.channelInactive(ctx);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            // empty if block
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketClientHandshakeException) {
            LOGGER.error("[DingTalk] connection establish error, please check connectionId={}", this.connectionId, cause);
        } else {
            LOGGER.error("[DingTalk] connection operation failed, connectionId={}", this.connectionId, cause);
        }
    }
}

