/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.UnsupportedPdu;
import com.digitalpetri.modbus.codec.MbapHeader;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.codec.ModbusTcpPayload;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpCodec
extends ByteToMessageCodec<ModbusTcpPayload> {
    private static final int HeaderLength = 7;
    private static final int HeaderSize = 6;
    private static final int LengthFieldIndex = 4;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ModbusPduEncoder encoder;
    private final ModbusPduDecoder decoder;

    public ModbusTcpCodec(ModbusPduEncoder encoder, ModbusPduDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    protected void encode(ChannelHandlerContext ctx, ModbusTcpPayload payload, ByteBuf buffer) throws Exception {
        int headerStartIndex = buffer.writerIndex();
        buffer.writeZero(7);
        int pduStartIndex = buffer.writerIndex();
        this.encoder.encode(payload.getModbusPdu(), buffer);
        int pduLength = buffer.writerIndex() - pduStartIndex;
        MbapHeader header = new MbapHeader(payload.getTransactionId(), pduLength + 1, payload.getUnitId());
        int currentWriterIndex = buffer.writerIndex();
        buffer.writerIndex(headerStartIndex);
        MbapHeader.encode(header, buffer);
        buffer.writerIndex(currentWriterIndex);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        int startIndex = buffer.readerIndex();
        while (buffer.readableBytes() >= 7 && buffer.readableBytes() >= this.getLength(buffer, startIndex) + 6) {
            try {
                MbapHeader mbapHeader = MbapHeader.decode(buffer);
                ModbusPdu modbusPdu = this.decoder.decode(buffer);
                if (modbusPdu instanceof UnsupportedPdu) {
                    int endIndex = startIndex + this.getLength(buffer, startIndex) + 6;
                    buffer.readerIndex(endIndex);
                }
                out.add(new ModbusTcpPayload(mbapHeader.getTransactionId(), mbapHeader.getUnitId(), modbusPdu));
            }
            catch (Throwable t) {
                throw new Exception("error decoding header/pdu", t);
            }
            startIndex = buffer.readerIndex();
        }
    }

    private int getLength(ByteBuf in, int startIndex) {
        return in.getUnsignedShort(startIndex + 4);
    }
}

