/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.ImmutableSortedMap;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.DiktatStep;
import com.diffplug.spotless.kotlin.KtLintStep;
import com.diffplug.spotless.kotlin.KtfmtStep;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class BaseKotlinExtension
extends FormatExtension {
    protected BaseKotlinExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public DiktatConfig diktat() {
        return this.diktat(DiktatStep.defaultVersionDiktat());
    }

    public DiktatConfig diktat(String version) {
        return new DiktatConfig(version);
    }

    public KtlintConfig ktlint() throws IOException {
        return this.ktlint(KtLintStep.defaultVersion());
    }

    public KtlintConfig ktlint(String version) throws IOException {
        return new KtlintConfig(version, Collections.emptyMap(), Collections.emptyList());
    }

    public KtfmtConfig ktfmt() {
        return this.ktfmt(KtfmtStep.defaultVersion());
    }

    public KtfmtConfig ktfmt(String version) {
        return new KtfmtConfig(version);
    }

    protected abstract boolean isScript();

    public final class DiktatConfig {
        private final String version;
        private FileSignature config;

        private DiktatConfig(String version) {
            Objects.requireNonNull(version, "version");
            this.version = version;
            BaseKotlinExtension.this.addStep(this.createStep());
        }

        public DiktatConfig configFile(Object file) throws IOException {
            this.config = file == null ? null : FileSignature.signAsList((File[])new File[]{BaseKotlinExtension.this.getProject().file(file)});
            BaseKotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return DiktatStep.create((String)this.version, (Provisioner)BaseKotlinExtension.this.provisioner(), (boolean)BaseKotlinExtension.this.isScript(), (FileSignature)this.config);
        }
    }

    public final class KtlintConfig {
        private final String version;
        private FileSignature editorConfigPath;
        private Map<String, Object> editorConfigOverride;
        private List<String> customRuleSets;

        private KtlintConfig(String version, Map<String, Object> editorConfigOverride, List<String> customRuleSets) throws IOException {
            Objects.requireNonNull(version);
            File defaultEditorConfig = BaseKotlinExtension.this.getProject().getRootProject().file((Object)".editorconfig");
            FileSignature editorConfigPath = defaultEditorConfig.exists() ? FileSignature.signAsList((File[])new File[]{defaultEditorConfig}) : null;
            this.version = version;
            this.editorConfigPath = editorConfigPath;
            this.editorConfigOverride = editorConfigOverride;
            this.customRuleSets = customRuleSets;
            BaseKotlinExtension.this.addStep(this.createStep());
        }

        public KtlintConfig setEditorConfigPath(@Nullable Object editorConfigPath) throws IOException {
            if (editorConfigPath == null) {
                this.editorConfigPath = null;
            } else {
                File editorConfigFile = BaseKotlinExtension.this.getProject().file(editorConfigPath);
                if (!editorConfigFile.exists()) {
                    throw new IllegalArgumentException("EditorConfig file does not exist: " + String.valueOf(editorConfigFile));
                }
                this.editorConfigPath = FileSignature.signAsList((File[])new File[]{editorConfigFile});
            }
            BaseKotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KtlintConfig editorConfigOverride(Map<String, Object> editorConfigOverride) {
            this.editorConfigOverride = ImmutableSortedMap.copyOf(editorConfigOverride);
            BaseKotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KtlintConfig customRuleSets(List<String> customRuleSets) {
            this.customRuleSets = ImmutableList.copyOf(customRuleSets);
            BaseKotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return KtLintStep.create((String)this.version, (Provisioner)BaseKotlinExtension.this.provisioner(), (FileSignature)this.editorConfigPath, this.editorConfigOverride, this.customRuleSets);
        }
    }

    public final class KtfmtConfig {
        private final String version;
        private final ConfigurableStyle configurableStyle = new ConfigurableStyle();
        private KtfmtStep.Style style;
        private KtfmtStep.KtfmtFormattingOptions options;

        private KtfmtConfig(String version) {
            Objects.requireNonNull(version);
            this.version = Objects.requireNonNull(version);
            BaseKotlinExtension.this.addStep(this.createStep());
        }

        public ConfigurableStyle metaStyle() {
            return this.style(KtfmtStep.Style.META);
        }

        public ConfigurableStyle dropboxStyle() {
            return this.style(KtfmtStep.Style.DROPBOX);
        }

        public ConfigurableStyle googleStyle() {
            return this.style(KtfmtStep.Style.GOOGLE);
        }

        public ConfigurableStyle kotlinlangStyle() {
            return this.style(KtfmtStep.Style.KOTLINLANG);
        }

        public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
            this.configurableStyle.configure(optionsConfiguration);
        }

        private ConfigurableStyle style(KtfmtStep.Style style) {
            this.style = style;
            BaseKotlinExtension.this.replaceStep(this.createStep());
            return this.configurableStyle;
        }

        private FormatterStep createStep() {
            return KtfmtStep.create((String)this.version, (Provisioner)BaseKotlinExtension.this.provisioner(), (KtfmtStep.Style)this.style, (KtfmtStep.KtfmtFormattingOptions)this.options);
        }

        public class ConfigurableStyle {
            public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
                KtfmtStep.KtfmtFormattingOptions ktfmtFormattingOptions = new KtfmtStep.KtfmtFormattingOptions();
                optionsConfiguration.accept(ktfmtFormattingOptions);
                KtfmtConfig.this.options = ktfmtFormattingOptions;
                BaseKotlinExtension.this.replaceStep(KtfmtConfig.this.createStep());
            }
        }
    }
}

