/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.integration.DiffMessageFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="not worth caching")
public abstract class SpotlessCheck
extends SpotlessTaskService.ClientTask {
    @Internal
    public abstract Property<String> getEncoding();

    @Input
    public abstract Property<String> getRunToFixMessage();

    public void performActionTest() throws IOException {
        this.performAction(true);
    }

    @TaskAction
    public void performAction() throws IOException {
        this.performAction(false);
    }

    private void performAction(boolean isTest) throws IOException {
        ConfigurableFileTree cleanFiles = this.getConfigCacheWorkaround().fileTree().from(this.getSpotlessCleanDirectory().get());
        ConfigurableFileTree lintsFiles = this.getConfigCacheWorkaround().fileTree().from(this.getSpotlessLintsDirectory().get());
        if (cleanFiles.isEmpty() && lintsFiles.isEmpty()) {
            this.getState().setDidWork(this.sourceDidWork());
        } else if (!isTest && this.applyHasRun()) {
            this.getState().setDidWork(false);
        } else {
            List<File> unformattedFiles = this.getUncleanFiles(cleanFiles);
            if (!unformattedFiles.isEmpty()) {
                throw new GradleException(DiffMessageFormatter.builder().runToFix((String)this.getRunToFixMessage().get()).formatterFolder(((Directory)this.getProjectDir().get()).getAsFile().toPath(), ((File)this.getSpotlessCleanDirectory().get()).toPath(), (String)this.getEncoding().get()).problemFiles(unformattedFiles).getMessage());
            }
            boolean detailed = false;
            throw new GradleException(super.allLintsErrorMsgDetailed(lintsFiles, detailed));
        }
    }

    @NotNull
    private List<File> getUncleanFiles(ConfigurableFileTree cleanFiles) {
        final ArrayList<File> uncleanFiles = new ArrayList<File>();
        cleanFiles.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                String path = fileVisitDetails.getPath();
                File originalSource = new File(((Directory)SpotlessCheck.this.getProjectDir().get()).getAsFile(), path);
                try {
                    byte[] userFile = Files.readAllBytes(originalSource.toPath());
                    ByteArrayOutputStream clean = new ByteArrayOutputStream();
                    fileVisitDetails.copyTo((OutputStream)clean);
                    byte[] formatted = clean.toByteArray();
                    if (!Arrays.equals(userFile, formatted)) {
                        uncleanFiles.add(originalSource);
                    }
                }
                catch (IOException e) {
                    throw ThrowingEx.asRuntime((Exception)e);
                }
            }
        });
        Collections.sort(uncleanFiles);
        return uncleanFiles;
    }

    @Internal
    abstract Property<String> getProjectPath();

    @Override
    void init(SpotlessTaskImpl impl) {
        super.init(impl);
        this.getProjectPath().set((Object)this.getProject().getPath());
        this.getEncoding().set((Object)impl.getEncoding());
        this.getRunToFixMessage().convention((Object)("Run '" + SpotlessCheck.calculateGradleCommand() + " " + this.getTaskPathPrefix() + "spotlessApply' to fix these violations."));
    }

    private String getTaskPathPrefix() {
        String path = (String)this.getProjectPath().get();
        return path.equals(":") ? ":" : path + ":";
    }

    private static String calculateGradleCommand() {
        return FileSignature.machineIsWin() ? "gradlew.bat" : "./gradlew";
    }
}

