/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SpotlessExtensionImpl
extends SpotlessExtension {
    final TaskProvider<?> rootCheckTask;
    final TaskProvider<?> rootApplyTask;
    final TaskProvider<?> rootDiagnoseTask;

    public SpotlessExtensionImpl(Project project) {
        super(project);
        this.rootCheckTask = project.getTasks().register("spotlessCheck", task -> {
            task.setGroup("verification");
            task.setDescription("Checks that sourcecode satisfies formatting steps.");
        });
        this.rootApplyTask = project.getTasks().register("spotlessApply", task -> {
            task.setGroup("verification");
            task.setDescription("Applies code formatting steps to sourcecode in-place.");
        });
        this.rootDiagnoseTask = project.getTasks().register("spotlessDiagnose", task -> task.setGroup("verification"));
        project.afterEvaluate(unused -> {
            if (this.enforceCheck) {
                project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{this.rootCheckTask}));
            }
        });
    }

    @Override
    protected void createFormatTasks(String name, FormatExtension formatExtension) {
        IdeHook.State ideHook = new IdeHook.State(this.project);
        TaskContainer tasks = this.project.getTasks();
        String taskName = "spotless" + SpotlessPlugin.capitalize(name);
        TaskProvider spotlessTask = tasks.register(taskName, SpotlessTaskImpl.class, task -> {
            task.init(this.getRegisterDependenciesTask().getTaskService());
            task.setGroup("verification");
            task.getIdeHookState().set((Object)ideHook);
            task.mustRunAfter(new Object[]{"clean"});
        });
        this.project.afterEvaluate(unused -> spotlessTask.configure(task -> {
            for (Action<FormatExtension> lazyAction : formatExtension.lazyActions) {
                lazyAction.execute((Object)formatExtension);
            }
            formatExtension.setupTask((SpotlessTask)((Object)((Object)task)));
        }));
        TaskProvider applyTask = tasks.register(taskName + "Apply", SpotlessApply.class, task -> {
            task.init((SpotlessTaskImpl)((Object)((Object)spotlessTask.get())));
            task.setGroup("verification");
            task.setEnabled(ideHook.path == null);
            task.dependsOn(new Object[]{spotlessTask});
        });
        this.rootApplyTask.configure(task -> task.dependsOn(new Object[]{ideHook.path == null ? applyTask : spotlessTask}));
        TaskProvider checkTask = tasks.register(taskName + "Check", SpotlessCheck.class, task -> {
            SpotlessTaskImpl source = (SpotlessTaskImpl)((Object)((Object)spotlessTask.get()));
            task.setGroup("verification");
            task.init(source);
            task.setEnabled(ideHook.path == null);
            task.dependsOn(new Object[]{source});
            task.mustRunAfter(new Object[]{applyTask});
        });
        this.rootCheckTask.configure(task -> task.dependsOn(new Object[]{checkTask}));
        TaskProvider diagnoseTask = tasks.register(taskName + "Diagnose", SpotlessDiagnoseTask.class, task -> {
            task.source = (SpotlessTask)((Object)((Object)spotlessTask.get()));
            task.setGroup("verification");
            task.mustRunAfter(new Object[]{"clean"});
        });
        this.rootDiagnoseTask.configure(task -> task.dependsOn(new Object[]{diagnoseTask}));
    }
}

